/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class BaseGraph
extends JComponent
implements IPanelListener,
ActionListener,
MouseListener,
MouseMotionListener {
    public static final Color darkGreen = new Color(0, 48, 0);
    public static final Color lightGreen = new Color(0, 255, 0);
    public static final Color lightBlue = new Color(0, 0, 255);
    private PropertyPanelScript script;
    private PropertyPanelManager ppmgr;
    private Hashtable elements;
    private int index;
    private StatusBar sbb;
    private int minElement = Integer.MAX_VALUE;
    private int maxElement = Integer.MIN_VALUE;
    private float stepX = 1.0f;
    private float minY = Float.MAX_VALUE;
    private float maxY = Float.MIN_VALUE;
    private float stepY = 1.0f;
    private int selectedAtom = -1;
    private String units;
    private int X;
    private int Y;
    private float gridX;
    private float gridY;
    public Color labelColor = Color.white;
    public float invalid;
    public Color gridColor = darkGreen;
    public Color locatorColor = lightBlue;
    public float yGranularity = 10.0f;
    public Color axisColor = Color.white;
    public Color selectedColor = Color.red;
    public Color curveColor = lightGreen;
    public int yLowerMargin = 30;
    public int xLeftMargin = 50;
    public int yCaptionGranularity = 5;
    public int xCaptionGranularity = 10;
    public int yTopMargin = 10;
    public Color locatorCaption = Color.black;
    public int yCaptionLength = 5;
    private Dimension oldD = new Dimension(0, 0);
    private boolean bInterpolateMissing = false;
    private boolean bDrawLocator = true;
    private boolean bLocatorFollowCurve = true;
    private boolean bOpaqueCoords = true;
    private boolean activated = false;
    private JMenuItem miSaveGraphToFile = new JMenuItem("Save Graph Image...", 83);
    private JMenuItem miPrintGraph = new JMenuItem("Print Graph Image...", 80);
    private JMenu pmContext = new JCoolMenu("Panel");
    private boolean mustRepaint = false;
    private String caption = "";
    private static Image iBuffer;
    private static int biw;
    private static int bih;
    private static Image iBack;
    private boolean fontInited = false;
    private MouseEvent emm;

    public int getMinElement() {
        return this.minElement;
    }

    public int getMaxElement() {
        return this.maxElement;
    }

    public BaseGraph(int n, PropertyPanelScript propertyPanelScript, PropertyPanelManager propertyPanelManager, ConfigManager configManager, DatabaseManager databaseManager, StatusBar statusBar, String string, float f, String string2) {
        this.caption = string2;
        this.invalid = f;
        this.units = string;
        this.script = propertyPanelScript;
        this.ppmgr = propertyPanelManager;
        this.elements = databaseManager.getElements();
        this.index = n;
        this.sbb = statusBar;
        Enumeration enumeration = this.elements.elements();
        while (enumeration.hasMoreElements()) {
            float f2;
            TElement tElement = (TElement)enumeration.nextElement();
            int n2 = tElement.AtomicNumber;
            if (n2 < this.minElement) {
                this.minElement = n2;
            }
            if (n2 > this.maxElement) {
                this.maxElement = n2;
            }
            if ((f2 = this.script.getGraphData(this.index, tElement)) == this.invalid) continue;
            if (f2 < this.minY) {
                this.minY = f2;
            }
            if (!(f2 > this.maxY)) continue;
            this.maxY = f2;
        }
        this.setBackground(Color.black);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        if (configManager.canWriteFiles()) {
            this.miSaveGraphToFile.addActionListener(this);
            this.miSaveGraphToFile.setActionCommand("FileSaveGraph");
            this.pmContext.add(this.miSaveGraphToFile);
        }
        if (configManager.canPrint()) {
            this.miPrintGraph.addActionListener(this);
            this.miPrintGraph.setActionCommand("FilePrintGraph");
            this.pmContext.add(this.miPrintGraph);
        }
        this.pmContext.setMnemonic('P');
    }

    public void setAtom(PanelEvent panelEvent) {
        this.selectedAtom = panelEvent.getElement().AtomicNumber;
        this.mustRepaint = true;
        if (!this.activated) {
            return;
        }
        this.repaint();
    }

    protected void paintBackground(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    protected void paintGrid(Graphics graphics) {
        Dimension dimension = this.getSize();
        float f = this.xLeftMargin;
        float f2 = this.yLowerMargin;
        graphics.setColor(this.gridColor);
        float f3 = this.minY;
        while (f3 < this.maxY) {
            f2 = (this.maxY - f3) / (this.maxY - this.minY) * (float)(dimension.height - this.yLowerMargin);
            graphics.drawLine(this.xLeftMargin - 15, Math.round(f2), dimension.width, Math.round(f2));
            f3 += this.yGranularity;
        }
        int n = this.minElement;
        while (n <= this.maxElement) {
            graphics.drawLine(Math.round(f), 0, Math.round(f), dimension.height - (this.yLowerMargin - 15));
            f += this.stepX;
            ++n;
        }
    }

    protected void paintXAxis(Graphics graphics) {
        Dimension dimension = this.getSize();
        float f = this.xLeftMargin;
        graphics.setColor(this.axisColor);
        graphics.drawLine(this.xLeftMargin - 15, dimension.height - (this.yLowerMargin - 15), dimension.width, dimension.height - (this.yLowerMargin - 15));
        int n = this.minElement;
        while (n <= this.maxElement) {
            if (n % this.xCaptionGranularity == 0) {
                graphics.drawLine(Math.round(f), dimension.height - (this.yLowerMargin - 5), Math.round(f), dimension.height);
                graphics.drawString(Integer.toString(n), Math.round(f), dimension.height - 3);
            } else if (n % 5 == 0) {
                graphics.drawLine(Math.round(f), dimension.height - (this.yLowerMargin - 7), Math.round(f), dimension.height - (this.yLowerMargin - 15));
            } else {
                graphics.drawLine(Math.round(f), dimension.height - (this.yLowerMargin - 10), Math.round(f), dimension.height - (this.yLowerMargin - 15));
            }
            f += this.stepX;
            ++n;
        }
    }

    protected void paintYAxis(Graphics graphics) {
        Dimension dimension = this.getSize();
        float f = this.yLowerMargin;
        graphics.setColor(this.axisColor);
        graphics.drawLine(this.xLeftMargin - 15, this.yTopMargin, this.xLeftMargin - 15, dimension.height - this.yLowerMargin + 15);
        int n = 1;
        float f2 = this.minY;
        while (f2 < this.maxY) {
            f = (this.maxY - f2) / (this.maxY - this.minY) * (float)(dimension.height - this.yLowerMargin);
            if (n % this.yCaptionGranularity == 0) {
                graphics.drawLine(0, Math.round(f), this.xLeftMargin - 5, Math.round(f));
                StringBuffer stringBuffer = new StringBuffer(Float.toString(f2));
                if (stringBuffer.length() > this.yCaptionLength) {
                    stringBuffer.setLength(this.yCaptionLength);
                }
                graphics.drawString(stringBuffer.toString(), 3, Math.round(f) - 5);
            } else if (n % 5 == 0) {
                graphics.drawLine(this.xLeftMargin - 7, Math.round(f), this.xLeftMargin - 15, Math.round(f));
            } else {
                graphics.drawLine(this.xLeftMargin - 10, Math.round(f), this.xLeftMargin - 15, Math.round(f));
            }
            ++n;
            f2 += this.yGranularity;
        }
    }

    protected void paintLocator(Graphics graphics) {
        String string;
        Dimension dimension = this.getSize();
        if (!this.bDrawLocator) {
            return;
        }
        graphics.setColor(this.locatorColor);
        graphics.drawLine(this.X, 0, this.X, dimension.height);
        graphics.drawLine(0, this.Y, dimension.width, this.Y);
        String string2 = Float.toString(this.gridY);
        if (string2.length() > 5) {
            string2 = string2.substring(0, 5);
        }
        if ((string = Float.toString(this.gridX)).length() > 5) {
            string = string.substring(0, 5);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string3 = "(" + string + "," + string2 + ")";
        Point point = this.checkVisible(string3, fontMetrics, dimension, this.X + 5, this.Y - 5);
        int n = point.x;
        int n2 = point.y;
        if (this.bOpaqueCoords) {
            graphics.setColor(new Color(102, 102, 153));
            graphics.drawRect(n, n2 - fontMetrics.getHeight() - 5, fontMetrics.stringWidth(string3) + 10, fontMetrics.getHeight() + 5);
            graphics.setColor(new Color(204, 204, 255));
            graphics.fillRect(n + 1, n2 - fontMetrics.getHeight() - 4, fontMetrics.stringWidth(string3) + 9, fontMetrics.getHeight() + 4);
            graphics.setColor(this.locatorCaption);
        }
        graphics.drawString(string3, n + 5, n2 - 5);
    }

    private Point checkVisible(String string, FontMetrics fontMetrics, Dimension dimension, int n, int n2) {
        if (n + fontMetrics.stringWidth(string) > dimension.width) {
            n = this.X - 5 - fontMetrics.stringWidth(string);
        }
        if (n2 - fontMetrics.getHeight() < 0) {
            n2 += 5 + fontMetrics.getHeight();
        }
        return new Point(n, n2);
    }

    protected void paintCurve(Graphics graphics) {
        Dimension dimension = this.getSize();
        float f = this.xLeftMargin;
        float f2 = -1.0f;
        float f3 = this.yLowerMargin;
        float f4 = -1.0f;
        int n = this.minElement;
        while (n <= this.maxElement) {
            float f5 = this.script.getGraphData(this.index, (TElement)this.elements.get(new Integer(n)));
            f3 = (this.maxY - f5) / (this.maxY - this.minY) * (float)(dimension.height - this.yLowerMargin);
            if ((double)f4 < 0.0) {
                f4 = f3;
            }
            if ((double)f2 < 0.0) {
                f2 = f;
            }
            if (f5 != this.invalid) {
                if (n == this.selectedAtom) {
                    graphics.setColor(this.labelColor);
                    graphics.drawString("Selection: " + Float.toString(f5) + " " + this.units, 0, 15);
                }
                graphics.setColor(this.curveColor);
                graphics.drawLine(Math.round(f2), Math.round(f4), Math.round(f), Math.round(f3));
                if (n == this.selectedAtom) {
                    String string;
                    String string2;
                    graphics.setColor(this.selectedColor);
                    graphics.drawLine(Math.round(f), 0, Math.round(f), dimension.height);
                    graphics.drawLine(0, Math.round(f3), dimension.width, Math.round(f3));
                    String string3 = Float.toString(this.getGridY(Math.round(f3)));
                    if (string3.length() > 5) {
                        string3 = string3.substring(0, 5);
                    }
                    if ((string2 = Float.toString(this.getGridX(Math.round(f)))).length() > 5) {
                        string2 = string2.substring(0, 5);
                    }
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n2 = Math.round(f) + 5;
                    if (n2 + fontMetrics.stringWidth(string = "(" + f5 + "," + string3 + ")") > dimension.width) {
                        n2 = Math.round(f) - 5 - fontMetrics.stringWidth(string);
                    }
                    int n3 = Math.round(f3) + 5 + graphics.getFontMetrics().getHeight();
                    if (this.bOpaqueCoords) {
                        graphics.setColor(new Color(102, 102, 153));
                        graphics.drawRect(n2, n3 - fontMetrics.getHeight(), fontMetrics.stringWidth(string) + 10, fontMetrics.getHeight() + 5);
                        graphics.setColor(new Color(204, 204, 255));
                        graphics.fillRect(n2 + 1, n3 - fontMetrics.getHeight() + 1, fontMetrics.stringWidth(string) + 9, fontMetrics.getHeight() + 4);
                        graphics.setColor(this.locatorCaption);
                    }
                    graphics.drawString(string, n2 + 5, n3);
                    graphics.setColor(this.axisColor);
                }
                f2 = f;
                f4 = f3;
            } else if (!this.bInterpolateMissing) {
                f2 = -1.0f;
                f4 = -1.0f;
            }
            f += this.stepX;
            ++n;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        boolean bl;
        if (!this.fontInited && this.getParent() != null) {
            this.setFont(this.getParent().getFont());
            this.fontInited = true;
        }
        Dimension dimension = this.getSize();
        boolean bl2 = bl = biw != dimension.width || bih != dimension.height;
        if (iBuffer == null || bl) {
            if (this.emm != null) {
                this.doMouseMove(this.emm.getX(), this.emm.getY());
            }
            iBuffer = this.createImage(dimension.width, dimension.height);
            biw = dimension.width;
            bih = dimension.height;
        }
        if (iBack == null || bl) {
            iBack = this.createImage(dimension.width, dimension.height);
        }
        Graphics graphics2 = iBuffer.getGraphics();
        graphics2.setFont(this.getFont());
        if (bl || this.mustRepaint) {
            Graphics graphics3 = iBack.getGraphics();
            graphics3.setFont(this.getFont());
            this.stepX = ((float)this.getSize().width - (float)this.xLeftMargin - 1.0f) / (float)(this.maxElement - this.minElement);
            this.stepY = ((float)this.getSize().height - (float)this.yLowerMargin - 1.0f) / (this.maxY - this.minY);
            this.paintBackground(graphics3);
            this.paintGrid(graphics3);
            this.paintXAxis(graphics3);
            this.paintYAxis(graphics3);
            this.paintCurve(graphics3);
        }
        graphics2.drawImage(iBack, 0, 0, null);
        this.paintLocator(graphics2);
        graphics.drawImage(iBuffer, 0, 0, null);
        this.mustRepaint = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
        this.ppmgr.setAtom(Math.round(this.gridX));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.doMouseMove(mouseEvent.getX(), mouseEvent.getY());
        this.emm = mouseEvent;
    }

    private void doMouseMove(int n, int n2) {
        this.X = n > this.xLeftMargin ? n : this.xLeftMargin;
        this.gridX = this.getGridX(this.X);
        if (this.gridX < 0.0f) {
            this.gridX = 0.0f;
        }
        if (!this.bDrawLocator) {
            return;
        }
        Dimension dimension = this.getSize();
        if (this.bLocatorFollowCurve) {
            int n3 = Math.round(this.getGridX(n));
            if (n3 < this.minElement || n3 > this.maxElement) {
                this.Y = Math.round(this.invalid);
                return;
            }
            float f = this.script.getGraphData(this.index, (TElement)this.elements.get(new Integer(n3)));
            this.Y = Math.round((this.maxY - f) / (this.maxY - this.minY) * (float)(dimension.height - this.yLowerMargin));
        } else {
            this.Y = n2 < dimension.height - this.yLowerMargin ? n2 : dimension.height - this.yLowerMargin;
        }
        this.gridY = this.getGridY(this.Y);
        if (this.gridY < 0.0f) {
            this.gridY = 0.0f;
        }
        this.repaint();
    }

    private int getPixelX(float f) {
        Dimension dimension = this.getSize();
        float f2 = f / (float)(this.maxElement - this.minElement);
        return Math.round(f2 * (float)(dimension.width - this.xLeftMargin));
    }

    private int getPixelY(float f) {
        Dimension dimension = this.getSize();
        float f2 = 1.0f - f / (this.maxY - this.minY);
        return Math.round(f2 * (float)(dimension.height - this.yLowerMargin));
    }

    private float getGridY(int n) {
        Dimension dimension = this.getSize();
        float f = dimension.height - this.yLowerMargin;
        float f2 = 1.0f - (float)n / f;
        return (this.maxY - this.minY) * f2 + this.minY;
    }

    private float getGridX(int n) {
        Dimension dimension = this.getSize();
        float f = dimension.width - this.xLeftMargin;
        float f2 = (float)(n - this.xLeftMargin) / f;
        return (float)(this.maxElement - this.minElement) * f2 + (float)this.minElement;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.ppmgr.setAtom(Math.round(this.gridX));
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("FileSaveGraph")) {
            this.OnFileSaveGraph();
            return;
        }
        string.equals("FilePrintGraph");
    }

    private void OnFileSaveGraph() {
        try {
            SimpleFileFilter simpleFileFilter = new SimpleFileFilter("bmp", "Windows Bitmap");
            DoFileDialog doFileDialog = new DoFileDialog((Component)this, "Save Graph Image...", 1, simpleFileFilter);
            String string = doFileDialog.getPath();
            if (string.equals("")) {
                return;
            }
            String string2 = DoFileDialog.getExtension(string);
            if (string2.equals(".bmp")) {
                BitmapCodec bitmapCodec = new BitmapCodec(this);
                if (iBuffer == null) {
                    this.repaint();
                }
                bitmapCodec.saveBitmap(string, iBuffer);
            }
            this.sbb.setText("Saved.");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void onActivate(PanelEvent panelEvent) {
        this.activated = true;
        this.mustRepaint = true;
        this.repaint();
        this.ppmgr.addMenu(this.pmContext);
    }

    public void onDeactivate(PanelEvent panelEvent) {
        this.activated = true;
        this.ppmgr.removeMenu(this.pmContext);
    }

    public void setStyle(PanelEvent panelEvent) {
        int n = panelEvent.getStyle();
        this.bInterpolateMissing = (n & 1) != 0;
        this.bDrawLocator = (n & 2) != 0;
        this.bLocatorFollowCurve = (n & 4) != 0;
        this.bOpaqueCoords = (n & 8) != 0;
        this.mustRepaint = true;
        this.repaint();
    }

    public String toString() {
        return this.caption;
    }

    private void OnFilePrintGraph() {
    }

    public void updateUI() {
        super.updateUI();
        if (this.pmContext != null) {
            this.pmContext.updateUI();
        }
    }
}

