/*
 * Decompiled with CFR 0.152.
 */
class FloatingNumber {
    boolean isExceptional;
    boolean isNegative;
    int decExponent;
    char[] digits;
    int nDigits;
    int bigIntExp;
    int bigIntNBits;
    boolean mustSetRoundDir = false;
    int roundDir;
    static final long signMask = Long.MIN_VALUE;
    static final long expMask = 0x7FF0000000000000L;
    static final long fractMask = 0xFFFFFFFFFFFFFL;
    static final int expShift = 52;
    static final int expBias = 1023;
    static final long fractHOB = 0x10000000000000L;
    static final long expOne = 0x3FF0000000000000L;
    static final int maxSmallBinExp = 62;
    static final int minSmallBinExp = -21;
    static final int maxDecimalDigits = 15;
    static final int maxDecimalExponent = 308;
    static final int minDecimalExponent = -324;
    static final int bigDecimalExponent = 324;
    static final long highbyte = -72057594037927936L;
    static final long highbit = Long.MIN_VALUE;
    static final long lowbytes = 0xFFFFFFFFFFFFFFL;
    static final int singleSignMask = Integer.MIN_VALUE;
    static final int singleExpMask = 2139095040;
    static final int singleFractMask = 0x7FFFFF;
    static final int singleExpShift = 23;
    static final int singleFractHOB = 0x800000;
    static final int singleExpBias = 127;
    static final int singleMaxDecimalDigits = 7;
    static final int singleMaxDecimalExponent = 38;
    static final int singleMinDecimalExponent = -45;
    static final int intDecimalDigits = 9;
    private static final double[] small10pow = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final float[] singleSmall10pow = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
    private static final double[] big10pow = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
    private static final double[] tiny10pow = new double[]{1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};
    private static final int maxSmallTen = small10pow.length - 1;
    private static final int singleMaxSmallTen = singleSmall10pow.length - 1;
    private static final int[] small5pow = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
    private static final long[] long5pow = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
    private static final int[] n5bits;
    private static final char[] infinity;
    private static final char[] notANumber;
    private static final char[] zero;

    private FloatingNumber(boolean bl, int n, char[] cArray, int n2, boolean bl2) {
        this.isNegative = bl;
        this.isExceptional = bl2;
        this.decExponent = n;
        this.digits = cArray;
        this.nDigits = n2;
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FloatingNumber readJavaFormatString(String var0) throws NumberFormatException {
        block30: {
            block31: {
                var1_1 = false;
                var2_2 = false;
                try {
                    var0 = var0.trim();
                    var5_3 = var0.length();
                    if (var5_3 == 0) {
                        throw new NumberFormatException("empty String");
                    }
                    var6_4 = 0;
                    var4_5 = var0.charAt(var6_4);
                    switch (var4_5) {
                        case 45: {
                            var1_1 = true;
                        }
                        case 43: {
                            ++var6_4;
                            var2_2 = true;
                            break;
                        }
                    }
                    var7_6 = new char[var5_3];
                    var8_7 = 0;
                    var9_8 = false;
                    var10_9 = 0;
                    var11_10 = 0;
                    var12_11 = 0;
                    if (true) ** GOTO lbl46
                }
                catch (StringIndexOutOfBoundsException v0) {}
                throw new NumberFormatException(var0);
                block18: while (true) {
                    var4_5 = var0.charAt(var6_4);
                    cfr_temp_0 = 0;
lbl29:
                    // 2 sources

                    while (true) {
                        switch (cfr_temp_0 == 0 ? var4_5 : cfr_temp_0) {
                            case 48: {
                                if (var8_7 > 0) {
                                    ++var12_11;
                                } else {
                                    ++var11_10;
                                }
                                ** GOTO lbl44
                            }
                            case 46: {
                                if (var9_8) {
                                    throw new NumberFormatException("multiple points");
                                }
                                var10_9 = var6_4;
                                if (var2_2) {
                                    --var10_9;
                                }
                                var9_8 = true;
lbl44:
                                // 4 sources

                                while (true) {
                                    ++var6_4;
lbl46:
                                    // 2 sources

                                    if (var6_4 < var5_3) continue block18;
                                    ** GOTO lbl-1000
                                    break;
                                }
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                if (var8_7 == 0) {
                                    var7_6 = FloatingNumber.zero;
                                    var8_7 = 1;
                                    if (var11_10 == 0) throw new NumberFormatException(var0);
                                }
                                var3_12 = var9_8 != false ? var10_9 - var11_10 : var8_7 + var12_11;
                                if ((var6_4 >= var5_3 || (var4_5 = var0.charAt(var6_4)) != 101) && var4_5 != 69) break block30;
                                var13_13 = 1;
                                var14_14 = 0;
                                var15_15 = false;
                                switch (var0.charAt(++var6_4)) {
                                    case '-': {
                                        var13_13 = -1;
                                    }
                                    case '+': {
                                        ++var6_4;
                                        break;
                                    }
                                }
                                var16_16 = var6_4;
                                if (true) ** GOTO lbl88
                            }
lbl66:
                            // 1 sources

                            while (true) {
                                var7_6[var8_7++] = 48;
                                cfr_temp_0 = 49;
                                --var12_11;
                                break;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                        }
                        break;
                    }
                    break;
                }
                break block31;
                ** while (true)
            }
            ** while (var12_11 > 0)
lbl75:
            // 1 sources

            var7_6[var8_7++] = var4_5;
            ** while (true)
            block22: do {
                if (var14_14 >= 0xCCCCCCC) {
                    var15_15 = true;
                }
                var4_5 = var0.charAt(var6_4++);
                switch (var4_5) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        var14_14 = var14_14 * 10 + (var4_5 - 48);
                        break;
                    }
                    default: {
                        --var6_4;
                        break block22;
                    }
                }
lbl88:
                // 2 sources

            } while (var6_4 < var5_3);
            var17_17 = 324 + var8_7 + var12_11;
            var3_12 = var15_15 || var14_14 > var17_17 ? var13_13 * var17_17 : (var3_12 += var13_13 * var14_14);
            if (var6_4 == var16_16) throw new NumberFormatException(var0);
        }
        if (var6_4 >= var5_3) return new FloatingNumber(var1_1, var3_12, var7_6, var8_7, false);
        if (var6_4 != var5_3 - 1) throw new NumberFormatException(var0);
        if (var0.charAt(var6_4) == 'f') return new FloatingNumber(var1_1, var3_12, var7_6, var8_7, false);
        if (var0.charAt(var6_4) == 'F') return new FloatingNumber(var1_1, var3_12, var7_6, var8_7, false);
        if (var0.charAt(var6_4) == 'd') return new FloatingNumber(var1_1, var3_12, var7_6, var8_7, false);
        if (var0.charAt(var6_4) != 'D') throw new NumberFormatException(var0);
        return new FloatingNumber(var1_1, var3_12, var7_6, var8_7, false);
    }

    public float floatValue() {
        int n = Math.min(this.nDigits, 8);
        int n2 = this.digits[0] - 48;
        int n3 = 1;
        while (n3 < n) {
            n2 = n2 * 10 + this.digits[n3] - 48;
            ++n3;
        }
        float f = n2;
        int n4 = this.decExponent - n;
        if (this.nDigits <= 7) {
            if (n4 == 0) {
                if (this.isNegative) {
                    return -f;
                }
                return f;
            }
            if (n4 >= 0) {
                if (n4 <= singleMaxSmallTen) {
                    f *= singleSmall10pow[n4];
                    if (this.isNegative) {
                        return -f;
                    }
                    return f;
                }
                int n5 = 7 - n;
                if (n4 <= singleMaxSmallTen + n5) {
                    f *= singleSmall10pow[n5];
                    f *= singleSmall10pow[n4 - n5];
                    if (this.isNegative) {
                        return -f;
                    }
                    return f;
                }
            } else if (n4 >= -singleMaxSmallTen) {
                f /= singleSmall10pow[-n4];
                if (this.isNegative) {
                    return -f;
                }
                return f;
            }
        } else if (this.decExponent >= this.nDigits && this.nDigits + this.decExponent <= 15) {
            long l = n2;
            int n6 = n;
            while (n6 < this.nDigits) {
                l = l * 10L + (long)(this.digits[n6] - 48);
                ++n6;
            }
            double d = l;
            n4 = this.decExponent - this.nDigits;
            f = (float)(d *= small10pow[n4]);
            if (this.isNegative) {
                return -f;
            }
            return f;
        }
        if (this.decExponent > 39) {
            if (this.isNegative) {
                return Float.NEGATIVE_INFINITY;
            }
            return Float.POSITIVE_INFINITY;
        }
        if (this.decExponent < -46) {
            if (this.isNegative) {
                return -0.0f;
            }
            return 0.0f;
        }
        return Float.NaN;
    }

    static {
        int[] nArray = new int[27];
        nArray[1] = 3;
        nArray[2] = 5;
        nArray[3] = 7;
        nArray[4] = 10;
        nArray[5] = 12;
        nArray[6] = 14;
        nArray[7] = 17;
        nArray[8] = 19;
        nArray[9] = 21;
        nArray[10] = 24;
        nArray[11] = 26;
        nArray[12] = 28;
        nArray[13] = 31;
        nArray[14] = 33;
        nArray[15] = 35;
        nArray[16] = 38;
        nArray[17] = 40;
        nArray[18] = 42;
        nArray[19] = 45;
        nArray[20] = 47;
        nArray[21] = 49;
        nArray[22] = 52;
        nArray[23] = 54;
        nArray[24] = 56;
        nArray[25] = 59;
        nArray[26] = 61;
        n5bits = nArray;
        infinity = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
        notANumber = new char[]{'N', 'a', 'N'};
        zero = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
    }
}

