/*
 * Decompiled with CFR 0.152.
 */
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;

public class AtomicTable
extends JPanel
implements IPanelListener,
ActionListener {
    private List layout;
    private Map elements;
    private Map types;
    private Map classes;
    private Map states;
    private Map buttons = new HashMap();
    private PropertyPanelManager ppmgr;
    private StatusBar sb;
    private JButton btnSelected;
    private TElement teSelected;
    private JMenuItem miSaveTable = new JMenuItem("Save Table Image...", 83);
    private JMenuItem miPrintTable = new JMenuItem("Print Table Image...", 80);
    private JMenu pmContext = new JCoolMenu("Table");

    public AtomicTable(LoadStatusManager loadStatusManager, PropertyPanelManager propertyPanelManager, DatabaseManager databaseManager, ConfigManager configManager, JPeriod99 jPeriod99, StatusBar statusBar) {
        Serializable serializable;
        this.layout = databaseManager.getLayout();
        this.elements = databaseManager.getElements();
        this.types = databaseManager.getTypes();
        this.classes = databaseManager.getClasses();
        this.states = databaseManager.getStates();
        this.ppmgr = propertyPanelManager;
        this.sb = statusBar;
        ListIterator listIterator = this.layout.listIterator();
        int n = Integer.parseInt((String)listIterator.next());
        int n2 = Integer.parseInt((String)listIterator.next());
        this.setBackground(Color.black);
        GridLayout gridLayout = new GridLayout(n2, n, 5, 5);
        this.setLayout(gridLayout);
        Insets insets = new Insets(0, 0, 0, 0);
        int n3 = 0;
        int n4 = 2;
        while (n4 < this.layout.size()) {
            String string = (String)listIterator.next();
            if (Character.isDigit(string.charAt(0))) {
                n3 = Integer.parseInt(string);
                if (n3 != 0) {
                    TElement tElement = (TElement)this.elements.get(new Integer(n3));
                    JButton jButton = new JButton(tElement.Symbol);
                    jButton.setMargin(insets);
                    jButton.setActionCommand(Integer.toString(tElement.AtomicNumber));
                    jButton.addActionListener(this);
                    jButton.setBackground(TElementType.getTypeColor(tElement.ElementType, this.types));
                    jButton.setToolTipText(String.valueOf(tElement.Name) + "(" + tElement.AtomicNumber + ")");
                    jButton.setBorder(new LineBorder(TClass.getClassColor(tElement.ClassType, this.classes), 2));
                    jButton.setForeground(TState.getStateColor(tElement.State, this.states));
                    this.buttons.put(new Integer(tElement.AtomicNumber), jButton);
                    this.add(jButton);
                } else {
                    this.add(new JLabel());
                }
            } else {
                serializable = new StringBuffer(string);
                ((StringBuffer)serializable).reverse();
                ((StringBuffer)serializable).setLength(((StringBuffer)serializable).length() - 1);
                ((StringBuffer)serializable).reverse();
                JLabel jLabel = new JLabel(((StringBuffer)serializable).toString(), 0);
                jLabel.setForeground(Color.white);
                this.add(jLabel);
            }
            ++n4;
        }
        this.ppmgr.addProperty(this);
        if (configManager.canWriteFiles()) {
            this.miSaveTable.addActionListener(this);
            this.miSaveTable.setActionCommand("FileSaveTable");
            this.pmContext.add(this.miSaveTable);
        }
        if (configManager.canPrint()) {
            this.miPrintTable.addActionListener(this);
            this.miPrintTable.setActionCommand("FilePrintTable");
            this.pmContext.add(this.miPrintTable);
        }
        this.pmContext.setMnemonic('T');
        serializable = jPeriod99.getJMenuBar();
        ((JMenuBar)serializable).add(this.pmContext);
        ((Container)serializable).invalidate();
        ((Container)serializable).validate();
    }

    private void OnFileSaveTable() {
        try {
            SimpleFileFilter simpleFileFilter = new SimpleFileFilter("jpg", "JPEG image");
            SimpleFileFilter simpleFileFilter2 = new SimpleFileFilter("bmp", "Windows Bitmap");
            FileFilter[] fileFilterArray = new FileFilter[]{simpleFileFilter, simpleFileFilter2};
            DoFileDialog doFileDialog = new DoFileDialog((Component)this, "Save Graph Image...", 1, fileFilterArray);
            String string = doFileDialog.getPath();
            if (string.equals("")) {
                return;
            }
            String string2 = DoFileDialog.getExtension(string);
            Dimension dimension = this.getSize();
            Image image = this.createImage(dimension.width, dimension.height);
            if (image == null) {
                System.err.println("ibuffer = null");
                return;
            }
            Graphics graphics = image.getGraphics();
            if (graphics == null) {
                System.err.println("gBuffer = null");
                return;
            }
            graphics.setClip(0, 0, dimension.width, dimension.height);
            this.paint(graphics);
            this.sb.setText("Saving " + string + "...");
            if (string2.equals(".bmp")) {
                BitmapCodec bitmapCodec = new BitmapCodec(this);
                bitmapCodec.saveBitmap(string, image);
            } else if (string2.equals(".jpg")) {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
                jPEGImageEncoder.encode((BufferedImage)image);
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
            }
            this.sb.setText("Saved " + string + ".");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("FileSaveTable")) {
            this.OnFileSaveTable();
        } else if (!string.equals("FilePrintTable")) {
            this.ppmgr.setAtom(Integer.parseInt(string));
        }
    }

    public void onActivate(PanelEvent panelEvent) {
    }

    public void onDeactivate(PanelEvent panelEvent) {
    }

    public void setAtom(PanelEvent panelEvent) {
        TElement tElement = panelEvent.getElement();
        JButton jButton = (JButton)this.buttons.get(new Integer(tElement.AtomicNumber));
        if (jButton == null) {
            return;
        }
        if (this.btnSelected != null) {
            this.btnSelected.setBackground(TElementType.getTypeColor(this.teSelected.ElementType, this.types));
            this.btnSelected.repaint();
        }
        this.btnSelected = jButton;
        this.teSelected = tElement;
        jButton.setBackground(jButton.getBackground().darker());
        jButton.repaint();
    }

    public void setStyle(PanelEvent panelEvent) {
    }

    public void updateUI() {
        super.updateUI();
        if (this.pmContext != null) {
            this.pmContext.updateUI();
        }
    }
}

