/*
 * Decompiled with CFR 0.152.
 */
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EtchedBorder;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class AtomAni
extends JPanel
implements IPanelListener,
ActionListener,
ItemListener {
    private static final String[] orbitals = new String[]{"1s", "2s", "2p", "3s", "3p", "4s", "3d", "4p", "5s", "4d", "5p", "6s", "4f", "5d", "6p", "7s", "5f", "6d", "7p"};
    private static final int[] iOrbitals = new int[]{2, 2, 6, 2, 6, 2, 10, 6, 2, 10, 6, 2, 14, 10, 6, 2, 14, 10, 2};
    private static final int[] nOrbitals;
    private static final Color[] cLabels;
    private static final String[] sLabels;
    private JCheckBox[] cbOrbitals = new JCheckBox[orbitals.length];
    private Group[] grpOrbitals = new Group[orbitals.length];
    private int iAtomicNumber;
    private static final BoundingSphere bounds;
    public static final Color3f white;
    public static final Color3f black;
    public static final Color3f ltGreen;
    public static final Color3f ltRed;
    public static final Color3f red;
    public static final Color3f purple;
    private Canvas3D c;
    private Primitive shape;
    private Transform3D t;
    private TransformGroup objTranz;
    private Appearance app;
    private JCheckBox cbRealtime = new JCheckBox("Realtime Update", true);
    private JPanel p;
    private boolean inDisplay = false;
    private boolean activated = false;
    private static final float[] fRadiiS;
    private static final float[] fRadiiP;
    private static final float[] fOffsetD;
    private static final float[] fOffsetF;

    public AtomAni() {
        JComponent jComponent;
        JComponent jComponent2;
        JComponent jComponent3;
        this.setBackground(new Color(0, 0, 0));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EtchedBorder());
        jPanel.setLayout(new FlowLayout(0));
        Dimension dimension = new Dimension(40, 40);
        int n = 0;
        while (n < cLabels.length) {
            jComponent3 = new JPanel();
            jComponent3.setMaximumSize(dimension);
            jComponent3.setBackground(cLabels[n]);
            jPanel.add(jComponent3);
            jComponent2 = new JLabel(sLabels[n]);
            jPanel.add(jComponent2);
            jPanel.add(new JSeparator(1));
            ++n;
        }
        this.cbRealtime.setActionCommand("Realtime");
        this.cbRealtime.addActionListener(this);
        jPanel.add(this.cbRealtime);
        jComponent3 = new JButton("Update");
        ((AbstractButton)jComponent3).setActionCommand("Update");
        ((AbstractButton)jComponent3).addActionListener(this);
        jPanel.add(jComponent3);
        this.add("North", jPanel);
        jComponent2 = new JPanel();
        jComponent2.setLayout(new GridLayout(orbitals.length, 1));
        int n2 = 0;
        while (n2 < orbitals.length) {
            jComponent = new JCheckBox(orbitals[n2]);
            jComponent2.add(jComponent);
            this.cbOrbitals[n2] = jComponent;
            ((AbstractButton)jComponent).addItemListener(this);
            ++n2;
        }
        jComponent = new JScrollPane(jComponent2, 20, 31);
        dimension = new Dimension(60, 2000);
        jComponent.setPreferredSize(dimension);
        jComponent.setMaximumSize(dimension);
        this.add("West", jComponent);
        this.p = new JPanel();
        this.p.setLayout(new BorderLayout());
        this.add("Center", this.p);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.cbRealtime.isSelected()) {
            this.displayOrbitals();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Update")) {
            this.displayOrbitals();
        }
    }

    public void setAtom(PanelEvent panelEvent) {
        this.iAtomicNumber = panelEvent.getElement().AtomicNumber;
        int n = 0;
        int n2 = 0;
        while (n2 < this.cbOrbitals.length) {
            this.cbOrbitals[n2].setEnabled(n < this.iAtomicNumber);
            n += iOrbitals[n2];
            ++n2;
        }
        if (!this.activated) {
            return;
        }
        if (this.cbRealtime.isSelected()) {
            this.displayOrbitals();
        }
    }

    public void onActivate(PanelEvent panelEvent) {
        this.activated = true;
    }

    public void onDeactivate(PanelEvent panelEvent) {
        this.activated = false;
    }

    public void setColorScheme(String string) {
    }

    public String toString() {
        return "Electron Animation";
    }

    private void displayOrbitals() {
        BranchGroup branchGroup;
        if (this.inDisplay) {
            return;
        }
        this.inDisplay = true;
        Canvas3D canvas3D = this.c;
        this.c = new Canvas3D(null);
        this.c.setBackground(new Color(0, 0, 0));
        this.p.add("Center", (Component)this.c);
        BranchGroup branchGroup2 = branchGroup = new BranchGroup();
        TransformGroup transformGroup = new TransformGroup();
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(0.01);
        transformGroup.setTransform(transform3D);
        branchGroup.addChild((Node)transformGroup);
        TransformGroup transformGroup2 = new TransformGroup();
        transformGroup2.setCapability(18);
        transformGroup2.setCapability(17);
        transformGroup.addChild((Node)transformGroup2);
        this.shape = new Cylinder(0.3f, 100.0f);
        this.app = this.shape.getAppearance();
        this.app.setMaterial(new Material(red, black, ltRed, white, 127.0f));
        this.t = new Transform3D();
        this.t.rotZ(1.5707963267948966);
        TransformGroup transformGroup3 = new TransformGroup(this.t);
        transformGroup3.addChild((Node)this.shape);
        transformGroup2.addChild((Node)transformGroup3);
        Font3D font3D = new Font3D(new Font("Dialog", 0, 12), new FontExtrusion());
        Text3D text3D = new Text3D(font3D, "X", new Point3f(50.0f, 0.0f, 0.0f));
        Shape3D shape3D = new Shape3D();
        this.app = new Appearance();
        Material material = new Material();
        material.setLightingEnable(true);
        this.app.setMaterial(material);
        shape3D.setGeometry((Geometry)text3D);
        shape3D.setAppearance(this.app);
        transformGroup2.addChild((Node)shape3D);
        this.shape = new Cylinder(0.3f, 100.0f);
        this.app = this.shape.getAppearance();
        this.app.setMaterial(new Material(red, black, ltRed, white, 127.0f));
        transformGroup2.addChild((Node)this.shape);
        font3D = new Font3D(new Font("Dialog", 0, 12), new FontExtrusion());
        text3D = new Text3D(font3D, "Y", new Point3f(0.0f, 50.0f, 0.0f));
        shape3D = new Shape3D();
        this.app = new Appearance();
        material = new Material();
        material.setLightingEnable(true);
        this.app.setMaterial(material);
        shape3D.setGeometry((Geometry)text3D);
        shape3D.setAppearance(this.app);
        transformGroup2.addChild((Node)shape3D);
        this.shape = new Cylinder(0.3f, 100.0f);
        this.app = this.shape.getAppearance();
        this.app.setMaterial(new Material(red, black, ltRed, white, 127.0f));
        this.t = new Transform3D();
        this.t.rotX(1.5707963267948966);
        transformGroup3 = new TransformGroup(this.t);
        transformGroup3.addChild((Node)this.shape);
        transformGroup2.addChild((Node)transformGroup3);
        font3D = new Font3D(new Font("Dialog", 0, 12), new FontExtrusion());
        text3D = new Text3D(font3D, "Z", new Point3f(0.0f, 0.0f, 50.0f));
        shape3D = new Shape3D();
        this.app = new Appearance();
        material = new Material();
        material.setLightingEnable(true);
        this.app.setMaterial(material);
        shape3D.setGeometry((Geometry)text3D);
        shape3D.setAppearance(this.app);
        transformGroup2.addChild((Node)shape3D);
        this.shape = new Sphere(0.75f);
        this.app = this.shape.getAppearance();
        this.app.setMaterial(new Material(new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.1f, 0.1f, 0.1f), new Color3f(1.0f, 1.0f, 1.0f), white, 80.0f));
        transformGroup2.addChild((Node)this.shape);
        if (this.cbOrbitals[0].isEnabled() && this.cbOrbitals[0].isSelected()) {
            this.makeOrbitalS(1, (Group)transformGroup2);
        }
        if (this.cbOrbitals[1].isEnabled() && this.cbOrbitals[1].isSelected()) {
            this.makeOrbitalS(2, (Group)transformGroup2);
        }
        if (this.cbOrbitals[2].isEnabled() && this.cbOrbitals[2].isSelected()) {
            this.makeOrbitalP(2, (Group)transformGroup2);
        }
        if (this.cbOrbitals[3].isEnabled() && this.cbOrbitals[3].isSelected()) {
            this.makeOrbitalS(3, (Group)transformGroup2);
        }
        if (this.cbOrbitals[4].isEnabled() && this.cbOrbitals[4].isSelected()) {
            this.makeOrbitalP(3, (Group)transformGroup2);
        }
        if (this.cbOrbitals[5].isEnabled() && this.cbOrbitals[5].isSelected()) {
            this.makeOrbitalS(4, (Group)transformGroup2);
        }
        if (this.cbOrbitals[6].isEnabled() && this.cbOrbitals[6].isSelected()) {
            this.makeOrbitalD(3, (Group)transformGroup2);
        }
        if (this.cbOrbitals[7].isEnabled() && this.cbOrbitals[7].isSelected()) {
            this.makeOrbitalP(4, (Group)transformGroup2);
        }
        if (this.cbOrbitals[8].isEnabled() && this.cbOrbitals[8].isSelected()) {
            this.makeOrbitalS(5, (Group)transformGroup2);
        }
        if (this.cbOrbitals[9].isEnabled() && this.cbOrbitals[9].isSelected()) {
            this.makeOrbitalD(4, (Group)transformGroup2);
        }
        if (this.cbOrbitals[10].isEnabled() && this.cbOrbitals[10].isSelected()) {
            this.makeOrbitalP(5, (Group)transformGroup2);
        }
        if (this.cbOrbitals[11].isEnabled() && this.cbOrbitals[11].isSelected()) {
            this.makeOrbitalS(6, (Group)transformGroup2);
        }
        if (this.cbOrbitals[12].isEnabled() && this.cbOrbitals[12].isSelected()) {
            this.makeOrbitalF(4, (Group)transformGroup2);
        }
        if (this.cbOrbitals[13].isEnabled() && this.cbOrbitals[13].isSelected()) {
            this.makeOrbitalD(5, (Group)transformGroup2);
        }
        if (this.cbOrbitals[14].isEnabled() && this.cbOrbitals[14].isSelected()) {
            this.makeOrbitalP(6, (Group)transformGroup2);
        }
        if (this.cbOrbitals[15].isEnabled() && this.cbOrbitals[15].isSelected()) {
            this.makeOrbitalS(7, (Group)transformGroup2);
        }
        if (this.cbOrbitals[16].isEnabled() && this.cbOrbitals[16].isSelected()) {
            this.makeOrbitalF(5, (Group)transformGroup2);
        }
        if (this.cbOrbitals[17].isEnabled() && this.cbOrbitals[17].isSelected()) {
            this.makeOrbitalD(6, (Group)transformGroup2);
        }
        if (this.cbOrbitals[18].isEnabled() && this.cbOrbitals[18].isSelected()) {
            this.makeOrbitalP(7, (Group)transformGroup2);
        }
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        MouseRotate mouseRotate = new MouseRotate();
        mouseRotate.setTransformGroup(transformGroup2);
        branchGroup.addChild((Node)mouseRotate);
        mouseRotate.setSchedulingBounds((Bounds)boundingSphere);
        MouseZoom mouseZoom = new MouseZoom();
        mouseZoom.setTransformGroup(transformGroup2);
        branchGroup.addChild((Node)mouseZoom);
        mouseZoom.setSchedulingBounds((Bounds)boundingSphere);
        MouseTranslate mouseTranslate = new MouseTranslate();
        mouseTranslate.setTransformGroup(transformGroup2);
        branchGroup.addChild((Node)mouseTranslate);
        mouseTranslate.setSchedulingBounds((Bounds)boundingSphere);
        Color3f color3f = new Color3f(0.0f, 0.0f, 0.0f);
        Background background = new Background(color3f);
        background.setApplicationBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)background);
        Color3f color3f2 = new Color3f(0.1f, 0.1f, 0.1f);
        AmbientLight ambientLight = new AmbientLight(color3f2);
        ambientLight.setInfluencingBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)ambientLight);
        Color3f color3f3 = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f vector3f = new Vector3f(4.0f, -7.0f, -12.0f);
        Color3f color3f4 = new Color3f(0.3f, 0.3f, 0.4f);
        Vector3f vector3f2 = new Vector3f(-6.0f, -2.0f, -1.0f);
        DirectionalLight directionalLight = new DirectionalLight(color3f3, vector3f);
        directionalLight.setInfluencingBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)directionalLight);
        DirectionalLight directionalLight2 = new DirectionalLight(color3f4, vector3f2);
        directionalLight2.setInfluencingBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)directionalLight2);
        SimpleUniverse simpleUniverse = new SimpleUniverse(this.c);
        simpleUniverse.getViewingPlatform().setNominalViewingTransform();
        simpleUniverse.addBranchGraph(branchGroup2);
        this.c.invalidate();
        if (canvas3D != null) {
            this.p.remove((Component)canvas3D);
        }
        this.inDisplay = false;
        this.p.invalidate();
        this.p.validate();
    }

    private void makeOrbitalS(int n, Group group) {
        Sphere sphere = new Sphere(fRadiiS[n]);
        this.app = sphere.getAppearance();
        this.app.setMaterial(new Material(new Color3f(0.2f, 0.1f, 0.0f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(1.0f, 0.5f, 0.0f), white, 80.0f));
        group.addChild((Node)sphere);
    }

    private void makeOrbitalP(int n, Group group) {
        float f = fRadiiP[n];
        this.shape = new Sphere(f);
        this.app = this.shape.getAppearance();
        this.app.setMaterial(new Material(new Color3f(0.0f, 0.0f, 0.1f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.0f, 0.0f, 1.0f), white, 80.0f));
        this.t = new Transform3D();
        this.t.set(new Vector3d((double)(-f / 2.0f), 0.0, 0.0));
        this.objTranz = new TransformGroup(this.t);
        this.objTranz.addChild((Node)this.shape);
        group.addChild((Node)this.objTranz);
        this.shape = new Sphere(f);
        this.app = this.shape.getAppearance();
        this.app.setMaterial(new Material(new Color3f(0.0f, 0.0f, 0.1f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.0f, 0.0f, 1.0f), white, 80.0f));
        this.t = new Transform3D();
        this.t.set(new Vector3d((double)(f / 2.0f), 0.0, 0.0));
        this.objTranz = new TransformGroup(this.t);
        this.objTranz.addChild((Node)this.shape);
        group.addChild((Node)this.objTranz);
        this.shape = new Sphere(f);
        this.app = this.shape.getAppearance();
        this.app.setMaterial(new Material(new Color3f(0.0f, 0.0f, 0.1f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.0f, 0.0f, 1.0f), white, 80.0f));
        this.t = new Transform3D();
        this.t.set(new Vector3d(0.0, (double)(-f / 2.0f), 0.0));
        this.objTranz = new TransformGroup(this.t);
        this.objTranz.addChild((Node)this.shape);
        group.addChild((Node)this.objTranz);
        this.shape = new Sphere(f);
        this.app = this.shape.getAppearance();
        this.app.setMaterial(new Material(new Color3f(0.0f, 0.0f, 0.1f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.0f, 0.0f, 1.0f), white, 80.0f));
        this.t = new Transform3D();
        this.t.set(new Vector3d(0.0, (double)(f / 2.0f), 0.0));
        this.objTranz = new TransformGroup(this.t);
        this.objTranz.addChild((Node)this.shape);
        group.addChild((Node)this.objTranz);
        this.shape = new Sphere(f);
        this.app = this.shape.getAppearance();
        this.app.setMaterial(new Material(new Color3f(0.0f, 0.0f, 0.1f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.0f, 0.0f, 1.0f), white, 80.0f));
        this.t = new Transform3D();
        this.t.set(new Vector3d(0.0, 0.0, (double)(-f / 2.0f)));
        this.objTranz = new TransformGroup(this.t);
        this.objTranz.addChild((Node)this.shape);
        group.addChild((Node)this.objTranz);
        this.shape = new Sphere(f);
        this.app = this.shape.getAppearance();
        this.app.setMaterial(new Material(new Color3f(0.0f, 0.0f, 0.1f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.0f, 0.0f, 1.0f), white, 80.0f));
        this.t = new Transform3D();
        this.t.set(new Vector3d(0.0, 0.0, (double)(f / 2.0f)));
        this.objTranz = new TransformGroup(this.t);
        this.objTranz.addChild((Node)this.shape);
        group.addChild((Node)this.objTranz);
    }

    private void makeOrbitalD(int n, Group group) {
        float f = fOffsetD[n];
        QuadCone quadCone = new QuadCone(2.0f, f, black, black, ltGreen, white, 80.0f);
        group.addChild((Node)quadCone);
        quadCone = new QuadCone(2.0f, f, black, black, ltGreen, white, 80.0f);
        Transform3D transform3D = new Transform3D();
        transform3D.rotZ(0.7853981633974483);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)quadCone);
        group.addChild((Node)transformGroup);
        quadCone = new QuadCone(2.0f, f, black, black, ltGreen, white, 80.0f);
        transform3D = new Transform3D();
        transform3D.rotY(1.5707963267948966);
        transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)quadCone);
        transform3D = new Transform3D();
        transform3D.rotX(0.7853981633974483);
        TransformGroup transformGroup2 = new TransformGroup(transform3D);
        transformGroup2.addChild((Node)transformGroup);
        group.addChild((Node)transformGroup2);
        quadCone = new QuadCone(2.0f, f, black, black, ltGreen, white, 80.0f);
        transform3D = new Transform3D();
        transform3D.rotX(1.5707963267948966);
        transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)quadCone);
        transform3D = new Transform3D();
        transform3D.rotY(0.7853981633974483);
        transformGroup2 = new TransformGroup(transform3D);
        transformGroup2.addChild((Node)transformGroup);
        group.addChild((Node)transformGroup2);
        IceCreamCone iceCreamCone = new IceCreamCone(2.0f, f, black, black, ltGreen, white, 80.0f);
        transform3D = new Transform3D();
        transform3D.rotX(1.5707963267948966);
        transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)iceCreamCone);
        group.addChild((Node)transformGroup);
        iceCreamCone = new IceCreamCone(2.0f, f, black, black, ltGreen, white, 80.0f);
        transform3D = new Transform3D();
        transform3D.rotX(-1.5707963267948966);
        transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)iceCreamCone);
        group.addChild((Node)transformGroup);
        Cylinder cylinder = new Cylinder(3.0f, f / 5.0f);
        this.app = cylinder.getAppearance();
        this.app.setMaterial(new Material(black, black, ltGreen, white, 80.0f));
        transform3D = new Transform3D();
        transform3D.rotX(-1.5707963267948966);
        transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)cylinder);
        group.addChild((Node)transformGroup);
    }

    private void makeOrbitalF(int n, Group group) {
        float f = fOffsetF[n];
        BiCone biCone = new BiCone(1.0f, f, new Color3f(0.6f, 0.0f, 0.6f), black, purple, white, 127.0f);
        Cylinder cylinder = new Cylinder(1.5f, f / 5.0f);
        this.app = cylinder.getAppearance();
        this.app.setMaterial(new Material(new Color3f(0.6f, 0.0f, 0.6f), black, purple, white, 127.0f));
        group.addChild((Node)cylinder);
        biCone = new BiCone(1.0f, f, new Color3f(0.6f, 0.0f, 0.6f), black, purple, white, 127.0f);
        this.t = new Transform3D();
        this.t.rotZ(1.5707963267948966);
        TransformGroup transformGroup = new TransformGroup(this.t);
        transformGroup.addChild((Node)biCone);
        group.addChild((Node)transformGroup);
        cylinder = new Cylinder(1.5f, f / 5.0f);
        this.app = cylinder.getAppearance();
        this.app.setMaterial(new Material(new Color3f(0.6f, 0.0f, 0.6f), black, purple, white, 127.0f));
        this.t = new Transform3D();
        this.t.rotZ(1.5707963267948966);
        transformGroup = new TransformGroup(this.t);
        transformGroup.addChild((Node)cylinder);
        group.addChild((Node)transformGroup);
        biCone = new BiCone(1.0f, f, new Color3f(0.6f, 0.0f, 0.6f), black, purple, white, 127.0f);
        this.t = new Transform3D();
        this.t.rotX(1.5707963267948966);
        transformGroup = new TransformGroup(this.t);
        transformGroup.addChild((Node)biCone);
        group.addChild((Node)transformGroup);
        cylinder = new Cylinder(1.5f, f / 5.0f);
        this.app = cylinder.getAppearance();
        this.app.setMaterial(new Material(new Color3f(0.6f, 0.0f, 0.6f), black, purple, white, 127.0f));
        this.t = new Transform3D();
        this.t.rotX(1.5707963267948966);
        transformGroup = new TransformGroup(this.t);
        transformGroup.addChild((Node)cylinder);
        group.addChild((Node)transformGroup);
        OctaCone octaCone = new OctaCone(1.0f, f, new Color3f(0.6f, 0.0f, 0.6f), black, purple, white, 127.0f);
        this.t = new Transform3D();
        this.t.rotY(0.7853981633974483);
        transformGroup = new TransformGroup(this.t);
        transformGroup.addChild((Node)octaCone);
        group.addChild((Node)transformGroup);
        octaCone = new OctaCone(1.0f, f, new Color3f(0.6f, 0.0f, 0.6f), black, purple, white, 127.0f);
        this.t = new Transform3D();
        this.t.rotZ(0.7853981633974483);
        transformGroup = new TransformGroup(this.t);
        transformGroup.addChild((Node)octaCone);
        group.addChild((Node)transformGroup);
        octaCone = new OctaCone(1.0f, f, new Color3f(0.6f, 0.0f, 0.6f), black, purple, white, 127.0f);
        this.t = new Transform3D();
        this.t.rotZ(0.7853981633974483);
        transformGroup = new TransformGroup(this.t);
        transformGroup.addChild((Node)octaCone);
        this.t = new Transform3D();
        this.t.rotY(1.5707963267948966);
        TransformGroup transformGroup2 = new TransformGroup(this.t);
        transformGroup2.addChild((Node)transformGroup);
        group.addChild((Node)transformGroup2);
        octaCone = new OctaCone(1.0f, f, new Color3f(0.6f, 0.0f, 0.6f), black, purple, white, 127.0f);
        this.t = new Transform3D();
        this.t.rotY(0.7853981633974483);
        transformGroup = new TransformGroup(this.t);
        transformGroup.addChild((Node)octaCone);
        group.addChild((Node)transformGroup);
    }

    public void setStyle(PanelEvent panelEvent) {
    }

    static {
        int[] nArray = new int[19];
        nArray[1] = 2;
        nArray[2] = 8;
        nArray[3] = 10;
        nArray[4] = 16;
        nArray[5] = 18;
        nArray[6] = 28;
        nArray[7] = 34;
        nArray[8] = 36;
        nArray[9] = 46;
        nArray[10] = 52;
        nArray[11] = 54;
        nArray[12] = 68;
        nArray[13] = 78;
        nArray[14] = 84;
        nArray[15] = 86;
        nArray[16] = 100;
        nArray[17] = 110;
        nArray[18] = 112;
        nOrbitals = nArray;
        cLabels = new Color[]{new Color(255, 255, 255), new Color(255, 128, 0), new Color(0, 0, 128), new Color(0, 255, 0), new Color(128, 0, 128)};
        sLabels = new String[]{"Nucleus", "s orbital", "p orbital", "d orbital", "f orbital"};
        bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        white = new Color3f(1.0f, 1.0f, 1.0f);
        black = new Color3f(0.0f, 0.0f, 0.0f);
        ltGreen = new Color3f(0.0f, 1.0f, 0.0f);
        ltRed = new Color3f(1.0f, 0.0f, 0.0f);
        red = new Color3f(0.5f, 0.0f, 0.0f);
        purple = new Color3f(0.5f, 0.0f, 0.5f);
        float[] fArray = new float[8];
        fArray[1] = 1.0f;
        fArray[2] = 1.75f;
        fArray[3] = 3.06f;
        fArray[4] = 5.36f;
        fArray[5] = 9.38f;
        fArray[6] = 15.94f;
        fArray[7] = 27.9f;
        fRadiiS = fArray;
        float[] fArray2 = new float[8];
        fArray2[2] = 1.75f;
        fArray2[3] = 3.06f;
        fArray2[4] = 5.36f;
        fArray2[5] = 9.38f;
        fArray2[6] = 15.94f;
        fArray2[7] = 27.9f;
        fRadiiP = fArray2;
        float[] fArray3 = new float[7];
        fArray3[3] = 5.36f;
        fArray3[4] = 9.38f;
        fArray3[5] = 15.94f;
        fArray3[6] = 27.9f;
        fOffsetD = fArray3;
        float[] fArray4 = new float[6];
        fArray4[4] = 16.25f;
        fArray4[5] = 28.25f;
        fOffsetF = fArray4;
    }
}

