/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.basic.BasicArrowButton;

public class JPeriod99
extends JFrame
implements WindowListener {
    private Container mainPanel;
    private ConfigManager cfgmgr;
    private IOManager iomgr;
    private DatabaseManager dbmgr;
    private PropertyPanelManager ppmgr;
    private MenuManager menumgr;
    private StatusBar sb;
    private AtomicTable atomicTable;
    private JPanel tableHolder;
    private JFrame tableFrame;
    private BasicArrowButton tableButton;
    private JPanel host = new JPanel();
    private JTree jtPropertyTree = new JTree();
    private JScrollPane spPropertyTree;
    private JPanel treeHolder;
    private JFrame treeFrame;
    private BasicArrowButton treeButton;
    private JSplitPane sp;
    private JSplitPane sp2;
    private boolean atomicTableOnForm = true;
    private boolean propertyTreeOnForm = true;

    public static void main(String[] stringArray) {
        JPeriod99.realMain(true, "", null);
    }

    public static JPeriod99 realMain(boolean bl, String string, Applet applet) {
        Object object;
        try {
            object = System.getSecurityManager();
            if (object != null) {
                ((SecurityManager)object).checkPropertiesAccess();
            }
            Properties properties = System.getProperties();
            ((Hashtable)properties).put("user.home", System.getProperty("user.dir"));
            ((Hashtable)properties).put("swing.plaf.metal.controlFont", "Arial-bold-12");
            ((Hashtable)properties).put("swing.plaf.metal.systemFont", "Arial-bold-12");
            ((Hashtable)properties).put("swing.plaf.metal.userFont", "Arial-bold-12");
            ((Hashtable)properties).put("swing.plaf.metal.smallFont", "Arial-bold-10");
        }
        catch (SecurityException securityException) {}
        object = new JPeriod99(bl, string, applet);
        ((Window)object).show();
        return object;
    }

    protected JPeriod99(boolean bl, String string, Applet applet) {
        super("JPeriod99 -- a Periodic Table by Darrick Wong");
        Window window;
        this.addWindowListener(this);
        this.setProperWindowSize();
        this.mainPanel = this.getContentPane();
        this.mainPanel.setLayout(new BorderLayout());
        this.cfgmgr = new ConfigManager(bl, string, applet);
        this.iomgr = new IOManager(this.cfgmgr);
        try {
            window = new ImageLoadStatusManager(this, new ImageIcon(this.iomgr.getFile("splash.jpg")).getImage());
        }
        catch (Exception exception) {
            window = new TextLoadStatusManager();
        }
        window.setMaximum(45);
        this.dbmgr = new DatabaseManager((LoadStatusManager)((Object)window), this.iomgr, this.cfgmgr);
        this.ppmgr = new PropertyPanelManager(this.jtPropertyTree, this.dbmgr, this.host, this);
        this.menumgr = new MenuManager((LoadStatusManager)((Object)window), this.cfgmgr, this, this.ppmgr);
        window.setProgress("Creating property tree UI...");
        this.createTree();
        window.setProgress("Creating menus...");
        this.setJMenuBar(this.menumgr.getMenuBar());
        window.setProgress("Creating status bar...");
        this.sb = new StatusBar("Hello.");
        this.mainPanel.add("South", this.sb);
        window.setProgress("Creating table UI...");
        this.atomicTable = new AtomicTable((LoadStatusManager)((Object)window), this.ppmgr, this.dbmgr, this.cfgmgr, this, this.sb);
        this.createTable();
        window.setProgress("Creating panel backing...");
        this.createPanel();
        window.setProgress("Laying components...");
        this.layoutControls();
        new PropertyPanelScript().run((LoadStatusManager)((Object)window), this.ppmgr, this.dbmgr, this.cfgmgr, this.sb);
        window.setProgress("Finishing...");
        window.setVisible(false);
        window.dispose();
        try {
            ImageIcon imageIcon = new ImageIcon(this.iomgr.getFile("dw.jpg"));
            Image image = imageIcon.getImage();
            ((Frame)this).setIconImage(image);
        }
        catch (IOException iOException) {}
        System.runFinalization();
        System.gc();
        System.runFinalization();
    }

    private void setProperWindowSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setSize(dimension.width * 3 / 4, dimension.height * 3 / 4);
        Dimension dimension2 = this.getSize();
        ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object == this) {
            if (this.cfgmgr.canExitVM()) {
                System.exit(0);
                return;
            }
        } else {
            if (object == this.treeFrame) {
                this.treeButton.doClick();
                return;
            }
            if (object == this.tableFrame) {
                this.tableButton.doClick();
            }
        }
    }

    private void layoutControls() {
        JComponent jComponent;
        JComponent jComponent2;
        if (this.sp != null) {
            this.mainPanel.remove(this.sp);
        }
        if (this.sp2 != null) {
            this.mainPanel.remove(this.sp2);
        }
        if (this.atomicTableOnForm) {
            this.sp = new JSplitPane(0, false, this.tableHolder, this.host);
            this.sp.setBorder(null);
            this.sp.setOneTouchExpandable(true);
            jComponent2 = this.sp;
            this.atomicTable.invalidate();
        } else {
            jComponent2 = this.host;
        }
        if (this.propertyTreeOnForm) {
            this.sp2 = new JSplitPane(1, false, this.treeHolder, jComponent2);
            this.sp2.setBorder(null);
            this.sp2.setOneTouchExpandable(true);
            jComponent = this.sp2;
        } else {
            jComponent = jComponent2;
        }
        this.mainPanel.add("Center", jComponent);
    }

    public void toggleTreeOnForm(boolean bl) {
        if (bl) {
            Dimension dimension = this.treeHolder.getSize();
            ((Component)this.treeFrame).setVisible(false);
            this.treeFrame.getContentPane().remove(this.treeHolder);
            this.treeButton.setDirection(1);
            this.propertyTreeOnForm = true;
            this.layoutControls();
            this.treeHolder.setPreferredSize(dimension);
            this.validate();
            return;
        }
        Dimension dimension = this.treeHolder.getSize();
        this.propertyTreeOnForm = false;
        this.layoutControls();
        this.treeButton.setDirection(5);
        this.treeFrame.getContentPane().add("Center", this.treeHolder);
        ((Component)this.treeFrame).setVisible(true);
        this.treeFrame.validate();
        this.validate();
        Dimension dimension2 = this.treeHolder.getSize();
        Dimension dimension3 = this.treeFrame.getSize();
        ((Component)this.treeFrame).setSize(new Dimension(dimension3.width + (dimension.width - dimension2.width), dimension3.height + (dimension.height - dimension2.height)));
        this.treeFrame.validate();
    }

    public void toggleTableOnForm(boolean bl) {
        if (bl) {
            Dimension dimension = this.tableHolder.getSize();
            ((Component)this.tableFrame).setVisible(false);
            this.tableFrame.getContentPane().remove(this.tableHolder);
            this.tableButton.setDirection(1);
            this.atomicTableOnForm = true;
            this.layoutControls();
            this.tableHolder.setPreferredSize(dimension);
            this.validate();
            return;
        }
        Dimension dimension = this.tableHolder.getSize();
        this.atomicTableOnForm = false;
        this.layoutControls();
        this.tableButton.setDirection(5);
        this.tableFrame.getContentPane().add("Center", this.tableHolder);
        ((Component)this.tableFrame).setVisible(true);
        this.tableFrame.validate();
        this.validate();
        Dimension dimension2 = this.tableHolder.getSize();
        Dimension dimension3 = this.tableFrame.getSize();
        ((Component)this.tableFrame).setSize(new Dimension(dimension3.width + (dimension.width - dimension2.width), dimension3.height + (dimension.height - dimension2.height)));
        this.tableFrame.validate();
    }

    private void createTree() {
        this.spPropertyTree = new JScrollPane(this.jtPropertyTree);
        this.treeHolder = new JPanel();
        this.treeFrame = new JFrame("Property Tree");
        this.treeFrame.addWindowListener(this);
        this.treeFrame.getContentPane().setLayout(new BorderLayout());
        this.treeButton = new BasicArrowButton(1);
        this.treeButton.setActionCommand("PropTreeOnForm");
        this.treeButton.addActionListener(this.menumgr);
        JLabel jLabel = new JLabel("Property Tree");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", jLabel);
        jPanel.add("East", this.treeButton);
        jPanel.setBorder(new EtchedBorder());
        this.treeHolder.setLayout(new BorderLayout());
        this.treeHolder.add("North", jPanel);
        this.treeHolder.add("Center", this.spPropertyTree);
    }

    private void createTable() {
        this.tableHolder = new JPanel();
        this.tableFrame = new JFrame("Atomic Table");
        this.tableFrame.addWindowListener(this);
        this.tableFrame.getContentPane().setLayout(new BorderLayout());
        this.tableButton = new BasicArrowButton(1);
        this.tableButton.setActionCommand("AtomicTableOnForm");
        this.tableButton.addActionListener(this.menumgr);
        JLabel jLabel = new JLabel("Atomic Table");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", jLabel);
        jPanel.add("East", this.tableButton);
        jPanel.setBorder(new EtchedBorder());
        this.tableHolder.setLayout(new BorderLayout());
        this.tableHolder.add("North", jPanel);
        this.tableHolder.add("Center", this.atomicTable);
        this.atomicTable.setMinimumSize(new Dimension(320, 240));
    }

    private void createPanel() {
        ElementName elementName = new ElementName();
        this.ppmgr.addProperty(elementName);
        this.host.setLayout(new BorderLayout());
        this.host.add("North", elementName);
    }

    public void OnHelpAbout() {
        Runtime runtime = Runtime.getRuntime();
        runtime.runFinalization();
        runtime.gc();
        runtime.runFinalization();
        StringBuffer stringBuffer = new StringBuffer("JPeriod99 is an interactive Java-based Periodic Table.  \n");
        stringBuffer.append("Based on JavaSoft's Swing 1.1 technology, this program uses a whole lot of \n");
        stringBuffer.append("Swing components to create the table, a bunch of tabs to show you the graphs of \n");
        stringBuffer.append("various atomic properties.  This program needs at least Swing 1.1b3 and Java 1.1, \n");
        stringBuffer.append("but prefers Java 1.2. In fact, Java 1.2 users should see a performance boost over 1.1,\n");
        stringBuffer.append("as I have adapted the graphs to use the Java2D APIs over the standard AWT APIs.\n");
        stringBuffer.append("\n");
        stringBuffer.append("Last major rewrite: 18 January 1999.\n");
        stringBuffer.append("\n");
        stringBuffer.append("Copyright\u00a9 1999 DW Software.\n");
        stringBuffer.append("\n");
        stringBuffer.append("This is the Java 1.2 with Java3D build.\n");
        stringBuffer.append("Last built: 04/12/1999 at 22:09:06.\n");
        stringBuffer.append("\n");
        stringBuffer.append("Running Java " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + ".\n");
        stringBuffer.append("Free memory: " + runtime.freeMemory() / 1024L + " KB\n");
        stringBuffer.append("Total memory: " + runtime.totalMemory() / 1024L + " KB\n");
        stringBuffer.append("Memory in use: " + (runtime.totalMemory() - runtime.freeMemory()) / 1024L + " KB");
        JOptionPane.showMessageDialog(this, stringBuffer.toString(), "JPeriod99 -- [19990412220906]", 1);
    }

    public void OnFileSave() {
        try {
            SimpleFileFilter simpleFileFilter = new SimpleFileFilter("txt", "Text File");
            String string = DoFileDialog.GetFileName((Component)this, "Save Element Data...", 1, simpleFileFilter);
            if (string.equals("")) {
                return;
            }
            this.sb.setText("Saving " + string + "...");
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
            String string2 = AllElementInfo.getAtomInfoAsText(this.ppmgr.getSelection(), this.dbmgr);
            dataOutputStream.writeBytes(string2);
            ConfigManager configManager = this.cfgmgr;
            dataOutputStream.writeBytes(System.getProperty("line.separator"));
            dataOutputStream.flush();
            fileOutputStream.close();
            this.sb.setText("Saved " + string + ".");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void OnFileSaveAll() {
        try {
            SimpleFileFilter simpleFileFilter = new SimpleFileFilter("txt", "Text File");
            String string = DoFileDialog.GetFileName((Component)this, "Save Element Data...", 1, simpleFileFilter);
            if (string.equals("")) {
                return;
            }
            this.sb.setText("Saving " + string + "...");
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
            this.dbmgr.saveEverything(dataOutputStream);
            ConfigManager configManager = this.cfgmgr;
            dataOutputStream.writeBytes(System.getProperty("line.separator"));
            dataOutputStream.flush();
            fileOutputStream.close();
            this.sb.setText("Saved " + string + ".");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void OnFilePrintEverything() {
    }

    public void OnFileSaveDatabase() {
        try {
            SimpleFileFilter simpleFileFilter = new SimpleFileFilter("tsv", "Tab Separated Values");
            String string = DoFileDialog.GetFileName((Component)this, "Save Database...", 1, simpleFileFilter);
            if (string.equals("")) {
                return;
            }
            this.sb.setText("Saving " + string + "...");
            InputStream inputStream = this.iomgr.getInputStream("Elements.dat");
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            byte[] byArray = new byte[16384];
            int n = 0;
            while ((n = inputStream.read(byArray)) >= 16384) {
                fileOutputStream.write(byArray);
            }
            fileOutputStream.write(byArray, 0, n);
            fileOutputStream.flush();
            fileOutputStream.close();
            inputStream.close();
            this.sb.setText("Saved " + string + ".");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void OnHelpAboutVM() {
        JSystemInfo jSystemInfo = new JSystemInfo();
        String[] stringArray = new String[]{"Refresh"};
        new JComponentDialog(this, "About Java VM", jSystemInfo, jSystemInfo, stringArray);
    }

    protected void makeWindowEvent(WindowEvent windowEvent) {
        this.processWindowEvent(windowEvent);
    }
}

