/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class MenuManager
implements ActionListener {
    private ConfigManager cfgmgr;
    private LoadStatusManager lsmgr;
    private JMenuBar jmb;
    private JPeriod99 parent;
    private PropertyPanelManager ppmgr;
    private JMenuBar mb;
    private int style = 14;
    private JMenuItem miFileSaveElement = new JMenuItem("Save Element...", 83);
    private JMenuItem miFileSaveAll = new JMenuItem("Save All Elements...", 65);
    private JMenuItem miFileSaveDatabase = new JMenuItem("Save Database...", 68);
    private JMenuItem miFilePrintEverything = new JMenuItem("Print Everything...", 69);
    private JMenuItem miFileExit = new JMenuItem("Exit", 120);
    private JMenuItem miHelpAbout = new JMenuItem("About...", 65);
    private JMenuItem miHelpAboutVM = new JMenuItem("About Java VM...", 86);
    private JCheckBoxMenuItem cmiGraphsInterpolate = new JCheckBoxMenuItem("Interpolate Missing Points", false);
    private JCheckBoxMenuItem cmiGraphsDrawLocator = new JCheckBoxMenuItem("Draw Locator", true);
    private JCheckBoxMenuItem cmiGraphsFollowCurve = new JCheckBoxMenuItem("Locator Follows Curve", true);
    private JCheckBoxMenuItem cmiOpaqueCoords = new JCheckBoxMenuItem("Opaque Coordinates", true);
    private JCheckBoxMenuItem cmiTableOnForm = new JCheckBoxMenuItem("Table on Main Window", true);
    private JCheckBoxMenuItem cmiPropListOnForm = new JCheckBoxMenuItem("Property List on Main Window", true);
    private JRadioButtonMenuItem rmiColorsColor = new JRadioButtonMenuItem("Color", true);
    private JRadioButtonMenuItem rmiColorsMono = new JRadioButtonMenuItem("Monochrome", false);
    private JCoolMenu mFile = new JCoolMenu("File");
    private JCoolMenu mColors = new JCoolMenu("Colors");
    private JCoolMenu mAppearance = new JCoolMenu("Appearance");
    private JCoolMenu mGraphs = new JCoolMenu("Graphs");
    private JCoolMenu mTable = new JCoolMenu("Table");
    private JCoolMenu mHelp = new JCoolMenu("Help");

    public MenuManager(LoadStatusManager loadStatusManager, ConfigManager configManager, JPeriod99 jPeriod99, PropertyPanelManager propertyPanelManager) {
        this.cfgmgr = configManager;
        this.lsmgr = loadStatusManager;
        this.parent = jPeriod99;
        this.ppmgr = propertyPanelManager;
    }

    private void initMenuItem(JCoolMenu jCoolMenu, JMenuItem jMenuItem, char c, String string) {
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string);
        jMenuItem.setMnemonic(c);
        jCoolMenu.add(jMenuItem);
    }

    private JMenuBar initMenus() {
        JMenuItem jMenuItem;
        Object object;
        Serializable serializable;
        this.lsmgr.setProgress("Creating \"File\" menu...");
        if (this.cfgmgr.canWriteFiles()) {
            serializable = this.mFile;
            object = this.miFileSaveElement;
            ((AbstractButton)object).addActionListener(this);
            ((AbstractButton)object).setActionCommand("FileSave");
            ((AbstractButton)object).setMnemonic('S');
            ((JMenu)serializable).add((JMenuItem)object);
            serializable = this.mFile;
            object = this.miFileSaveAll;
            ((AbstractButton)object).addActionListener(this);
            ((AbstractButton)object).setActionCommand("FileSaveAll");
            ((AbstractButton)object).setMnemonic('A');
            ((JMenu)serializable).add((JMenuItem)object);
            serializable = this.mFile;
            object = this.miFileSaveDatabase;
            ((AbstractButton)object).addActionListener(this);
            ((AbstractButton)object).setActionCommand("FileSaveDBase");
            ((AbstractButton)object).setMnemonic('D');
            ((JMenu)serializable).add((JMenuItem)object);
        }
        this.mFile.add(new JSeparator());
        if (this.cfgmgr.canPrint()) {
            serializable = this.mFile;
            object = this.miFilePrintEverything;
            ((AbstractButton)object).addActionListener(this);
            ((AbstractButton)object).setActionCommand("FilePrintEverything");
            ((AbstractButton)object).setMnemonic('E');
            ((JMenu)serializable).add((JMenuItem)object);
        }
        if (!this.cfgmgr.canExitVM()) {
            this.miFileExit.setText("Close");
            this.miFileExit.setMnemonic('C');
        }
        this.miFileExit.addActionListener(this);
        this.miFileExit.setActionCommand("FileExit");
        this.mFile.add(this.miFileExit);
        this.mFile.setMnemonic('F');
        this.lsmgr.setProgress("Creating \"Colors\" menu...");
        serializable = new ButtonGroup();
        object = this.mColors;
        JRadioButtonMenuItem jRadioButtonMenuItem = this.rmiColorsColor;
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setActionCommand("ColorsColor");
        jRadioButtonMenuItem.setMnemonic('C');
        ((JMenu)object).add(jRadioButtonMenuItem);
        ((ButtonGroup)serializable).add(this.rmiColorsColor);
        object = this.mColors;
        jRadioButtonMenuItem = this.rmiColorsMono;
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setActionCommand("ColorsMono");
        jRadioButtonMenuItem.setMnemonic('M');
        ((JMenu)object).add(jRadioButtonMenuItem);
        ((ButtonGroup)serializable).add(this.rmiColorsMono);
        this.lsmgr.setProgress("Creating \"Appearance\" menu...");
        this.mAppearance.setMnemonic('A');
        serializable = new ButtonGroup();
        object = UIManager.getLookAndFeel();
        boolean bl = false;
        try {
            this.getClass();
            Class.forName("javax.swing.plaf.mac.MacLookAndFeel");
            UIManager.installLookAndFeel("Macintosh", "javax.swing.plaf.mac.MacLookAndFeel");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (!bl) {
            try {
                this.getClass();
                Class.forName("com.sun.java.swing.plaf.mac.MacLookAndFeel");
                UIManager.installLookAndFeel("Macintosh", "com.sun.java.swing.plaf.mac.MacLookAndFeel");
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = 0;
        while (n < lookAndFeelInfoArray.length) {
            jMenuItem = new JRadioButtonMenuItem(lookAndFeelInfoArray[n].getName(), ((LookAndFeel)object).getName().equals(lookAndFeelInfoArray[n].getName()));
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand(lookAndFeelInfoArray[n].getClassName());
            ((ButtonGroup)serializable).add(jMenuItem);
            this.mAppearance.add(jMenuItem);
            ++n;
        }
        this.mColors.setMnemonic('C');
        this.lsmgr.setProgress("Creating \"Graphs\" menu...");
        jMenuItem = this.mGraphs;
        JMenuItem jMenuItem2 = this.cmiGraphsInterpolate;
        jMenuItem2.addActionListener(this);
        jMenuItem2.setActionCommand("GraphsInterpolate");
        jMenuItem2.setMnemonic('I');
        ((JMenu)jMenuItem).add(jMenuItem2);
        jMenuItem = this.mGraphs;
        jMenuItem2 = this.cmiGraphsDrawLocator;
        jMenuItem2.addActionListener(this);
        jMenuItem2.setActionCommand("GraphsDrawLocator");
        jMenuItem2.setMnemonic('L');
        ((JMenu)jMenuItem).add(jMenuItem2);
        jMenuItem = this.mGraphs;
        jMenuItem2 = this.cmiGraphsFollowCurve;
        jMenuItem2.addActionListener(this);
        jMenuItem2.setActionCommand("GraphsFollowCurve");
        jMenuItem2.setMnemonic('F');
        ((JMenu)jMenuItem).add(jMenuItem2);
        jMenuItem = this.mGraphs;
        jMenuItem2 = this.cmiOpaqueCoords;
        jMenuItem2.addActionListener(this);
        jMenuItem2.setActionCommand("OpaqueCoords");
        jMenuItem2.setMnemonic('O');
        ((JMenu)jMenuItem).add(jMenuItem2);
        this.mGraphs.setMnemonic('G');
        this.lsmgr.setProgress("Creating \"Table\" menu...");
        jMenuItem = this.mTable;
        jMenuItem2 = this.cmiTableOnForm;
        jMenuItem2.addActionListener(this);
        jMenuItem2.setActionCommand("AtomicTableOnForm");
        jMenuItem2.setMnemonic('T');
        ((JMenu)jMenuItem).add(jMenuItem2);
        jMenuItem = this.mTable;
        jMenuItem2 = this.cmiPropListOnForm;
        jMenuItem2.addActionListener(this);
        jMenuItem2.setActionCommand("PropTreeOnForm");
        jMenuItem2.setMnemonic('P');
        ((JMenu)jMenuItem).add(jMenuItem2);
        this.mTable.setMnemonic('T');
        this.lsmgr.setProgress("Creating \"Help\" menu...");
        jMenuItem = this.mHelp;
        jMenuItem2 = this.miHelpAboutVM;
        jMenuItem2.addActionListener(this);
        jMenuItem2.setActionCommand("HelpAboutVM");
        jMenuItem2.setMnemonic('V');
        ((JMenu)jMenuItem).add(jMenuItem2);
        jMenuItem = this.mHelp;
        jMenuItem2 = this.miHelpAbout;
        jMenuItem2.addActionListener(this);
        jMenuItem2.setActionCommand("HelpAbout");
        jMenuItem2.setMnemonic('A');
        ((JMenu)jMenuItem).add(jMenuItem2);
        this.mHelp.setMnemonic('H');
        this.mb = new JMenuBar();
        this.mb.add(this.mFile);
        this.mb.add(this.mAppearance);
        this.mb.add(this.mGraphs);
        this.mb.add(this.mTable);
        this.mb.add(this.mHelp);
        this.mb.setBorder(null);
        return this.mb;
    }

    public JMenuBar getMenuBar() {
        if (this.jmb == null) {
            this.jmb = this.initMenus();
        }
        return this.jmb;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("FileSave")) {
            this.parent.OnFileSave();
            return;
        }
        if (string.equals("FileSaveAll")) {
            this.parent.OnFileSaveAll();
            return;
        }
        if (string.equals("FileSaveDBase")) {
            this.parent.OnFileSaveDatabase();
            return;
        }
        if (string.equals("FilePrintEverything")) {
            this.parent.OnFilePrintEverything();
            return;
        }
        if (string.equals("FileExit")) {
            this.parent.dispose();
            if (this.cfgmgr.canExitVM()) {
                System.exit(0);
                return;
            }
            this.parent.makeWindowEvent(new WindowEvent(this.parent, 201));
            return;
        }
        if (!string.equals("ColorsColor") && !string.equals("ColorsMono")) {
            if (string.equals("GraphsInterpolate")) {
                JCheckBoxMenuItem jCheckBoxMenuItem = this.cmiGraphsInterpolate;
                this.style = jCheckBoxMenuItem.isSelected() ? (this.style |= 1) : (this.style &= 0xFFFFFFFE);
                this.ppmgr.setStyle(this.style);
                return;
            }
            if (string.equals("GraphsDrawLocator")) {
                JCheckBoxMenuItem jCheckBoxMenuItem = this.cmiGraphsDrawLocator;
                this.style = jCheckBoxMenuItem.isSelected() ? (this.style |= 2) : (this.style &= 0xFFFFFFFD);
                this.ppmgr.setStyle(this.style);
                return;
            }
            if (string.equals("GraphsFollowCurve")) {
                JCheckBoxMenuItem jCheckBoxMenuItem = this.cmiGraphsFollowCurve;
                this.style = jCheckBoxMenuItem.isSelected() ? (this.style |= 4) : (this.style &= 0xFFFFFFFB);
                this.ppmgr.setStyle(this.style);
                return;
            }
            if (string.equals("OpaqueCoords")) {
                JCheckBoxMenuItem jCheckBoxMenuItem = this.cmiOpaqueCoords;
                this.style = jCheckBoxMenuItem.isSelected() ? (this.style |= 8) : (this.style &= 0xFFFFFFF7);
                this.ppmgr.setStyle(this.style);
                return;
            }
            if (string.equals("PropTreeOnForm")) {
                JCheckBoxMenuItem jCheckBoxMenuItem = this.cmiPropListOnForm;
                if (actionEvent.getSource() != jCheckBoxMenuItem) {
                    jCheckBoxMenuItem.setSelected(!jCheckBoxMenuItem.isSelected());
                }
                this.parent.toggleTreeOnForm(jCheckBoxMenuItem.isSelected());
                return;
            }
            if (string.equals("AtomicTableOnForm")) {
                JCheckBoxMenuItem jCheckBoxMenuItem = this.cmiTableOnForm;
                if (actionEvent.getSource() != jCheckBoxMenuItem) {
                    jCheckBoxMenuItem.setSelected(!jCheckBoxMenuItem.isSelected());
                }
                this.parent.toggleTableOnForm(jCheckBoxMenuItem.isSelected());
                return;
            }
            if (string.equals("HelpAboutVM")) {
                this.parent.OnHelpAboutVM();
                return;
            }
            if (string.equals("HelpAbout")) {
                this.parent.OnHelpAbout();
                return;
            }
            if (string.indexOf(46) > -1) {
                try {
                    UIManager.setLookAndFeel(string);
                    SwingUtilities.updateComponentTreeUI(this.parent);
                    this.ppmgr.updateComponentTreeUI();
                    SwingUtilities.updateComponentTreeUI(this.mb);
                    return;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return;
                }
            }
        }
    }
}

