/*
 * Decompiled with CFR 0.152.
 */
class PropertyPanelScript {
    public static final String text = "Text";
    public static final String html = "HTML";
    public static final String table = "Table";
    public static final String panels = "Panels";
    public static final String graph = "Graph";

    public void run(LoadStatusManager loadStatusManager, PropertyPanelManager propertyPanelManager, DatabaseManager databaseManager, ConfigManager configManager, StatusBar statusBar) {
        loadStatusManager.setProgress("Adding tree nodes...");
        propertyPanelManager.addRootNode(text);
        propertyPanelManager.addRootNode(html);
        propertyPanelManager.addRootNode(table);
        propertyPanelManager.addRootNode(panels);
        propertyPanelManager.addRootNode(graph);
        loadStatusManager.setProgress("Adding table of all properties...");
        AllElementInfo allElementInfo = new AllElementInfo(propertyPanelManager, databaseManager, configManager);
        propertyPanelManager.addDefaultPropertyPanel("Root", allElementInfo, allElementInfo);
        loadStatusManager.setProgress("Creating text property panels...");
        TextPanel textPanel = new TextPanel(this, 0, "Electron Config", propertyPanelManager, configManager);
        propertyPanelManager.addPropertyPanel(text, textPanel, textPanel);
        textPanel = new TextPanel(this, 1, "Half Life", propertyPanelManager, configManager);
        propertyPanelManager.addPropertyPanel(text, textPanel, textPanel);
        textPanel = new TextPanel(this, 2, "Hazards:", propertyPanelManager, configManager);
        propertyPanelManager.addPropertyPanel(text, textPanel, textPanel);
        textPanel = new TextPanel(this, 3, "Element Abundances:", propertyPanelManager, configManager);
        propertyPanelManager.addPropertyPanel(text, textPanel, textPanel);
        textPanel = new TextPanel(this, 4, "CAS Registry Number", propertyPanelManager, configManager);
        propertyPanelManager.addPropertyPanel(text, textPanel, textPanel);
        textPanel = new TextPanel(this, 5, "Crystal Structure", propertyPanelManager, configManager);
        propertyPanelManager.addPropertyPanel(text, textPanel, textPanel);
        loadStatusManager.setProgress("Creating HTML property panels...");
        HTMLPanel hTMLPanel = new HTMLPanel(this, 0, configManager, "Element Info");
        propertyPanelManager.addPropertyPanel(html, hTMLPanel, hTMLPanel);
        loadStatusManager.setProgress("Creating table property panels...");
        IonEnthalpy ionEnthalpy = new IonEnthalpy(configManager, propertyPanelManager);
        propertyPanelManager.addPropertyPanel(table, ionEnthalpy, ionEnthalpy);
        Zeff zeff = new Zeff(configManager, propertyPanelManager);
        propertyPanelManager.addPropertyPanel(table, zeff, zeff);
        loadStatusManager.setProgress("Creating panels...");
        AtomAni atomAni = new AtomAni();
        propertyPanelManager.addPropertyPanel(panels, atomAni, atomAni);
        BodyMeasurement bodyMeasurement = new BodyMeasurement();
        propertyPanelManager.addPropertyPanel(panels, bodyMeasurement, bodyMeasurement);
        loadStatusManager.setProgress("Creating graphs...");
        int n = 0;
        BaseGraph baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "amu", 0.0f, "Atomic Mass");
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new TempGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "K", -1.0f, "Melting Point");
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new TempGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "K", -1.0f, "Boiling Point");
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "(g/cm^3)", -1.0f, "Density");
        baseGraph.yGranularity = 1.0f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "(cal / gK)", -1.0f, "Specific Heat");
        baseGraph.yGranularity = 0.1f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        loadStatusManager.setProgress("Created 5 graphs...");
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "eV", -1.0f, "Ionization Energy");
        baseGraph.yGranularity = 1.0f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "(Kcal / g*atom)", -1.0f, "Vaporization Energy");
        baseGraph.yGranularity = 10.0f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "Angstroms", -1.0f, "Atomic Radius");
        baseGraph.yGranularity = 0.1f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "MHz", -1.0f, "Atomic Frequency at 2.344T");
        baseGraph.yGranularity = 5.0f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "", -1.0f, "Pauling Electronegativity");
        baseGraph.yGranularity = 0.1f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        loadStatusManager.setProgress("Created 10 graphs...");
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "", -1.0f, "Sanderson Electronegativity");
        baseGraph.yGranularity = 0.1f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "", -1.0f, "Rochow Electronegativity");
        baseGraph.yGranularity = 0.1f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "", -1.0f, "Mulliken Electronegativity");
        baseGraph.yGranularity = 0.1f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "", -1.0f, "Allen Electronegativity");
        baseGraph.yGranularity = 0.1f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "g/kg", -1.0f, "Element mass vs. body mass");
        baseGraph.yGranularity = 10.0f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        loadStatusManager.setProgress("Created 15 graphs...");
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "kJ/mol", -1.0f, "Electron Affinity");
        baseGraph.yGranularity = 10.0f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "cm^3", -1.0f, "Molar Volume");
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "m/s", -1.0f, "Sound Velocity");
        baseGraph.yGranularity = 500.0f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "u-ohms", -1.0f, "Resistance");
        baseGraph.yGranularity = 1000.0f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "ppb", -1.0f, "Weight in Universe");
        baseGraph.yGranularity = 1.0E7f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        loadStatusManager.setProgress("Created 20 graphs...");
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "ppb", -1.0f, "Atoms in Universe");
        baseGraph.yGranularity = 1.0E7f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "ppb", -1.0f, "Weight in Sun");
        baseGraph.yGranularity = 1.0E7f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "ppb", -1.0f, "Atoms in Sun");
        baseGraph.yGranularity = 1.0E7f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "ppb", -1.0f, "Weight in Meteors");
        baseGraph.yGranularity = 1.0E7f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "ppb", -1.0f, "Atoms in Meteors");
        baseGraph.yGranularity = 1.0E7f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        loadStatusManager.setProgress("Created 25 graphs...");
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "ppb", -1.0f, "Weight in Crustal Rocks");
        baseGraph.yGranularity = 1.0E7f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "ppb", -1.0f, "Atoms in Crustal Rocks");
        baseGraph.yGranularity = 1.0E7f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "ppb", -1.0f, "Weight in Sea Water");
        baseGraph.yGranularity = 1.0E7f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "ppb", -1.0f, "Atoms in Sea Water");
        baseGraph.yGranularity = 1.0E7f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "ppb", -1.0f, "Weight in Streams");
        baseGraph.yGranularity = 1.0E7f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        loadStatusManager.setProgress("Created 30 graphs...");
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "ppb", -1.0f, "Atoms in Streams");
        baseGraph.yGranularity = 1.0E7f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "ppb", -1.0f, "Weight in Humans");
        baseGraph.yGranularity = 1.0E7f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "ppb", -1.0f, "Atoms in Humans");
        baseGraph.yGranularity = 1.0E7f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "\u00c5", -1.0f, "Covalent Radius");
        baseGraph.yGranularity = 0.1f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "cm\u00b3/mol", -1.0f, "Atomic Volume");
        baseGraph.yGranularity = 5.0f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        loadStatusManager.setProgress("Created 35 graphs...");
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "kJ/mol", -1.0f, "Heat of Vaporization");
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "W/cmK", -1.0f, "Thermal Conductivity");
        baseGraph.yGranularity = 0.5f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "kJ/mol", -1.0f, "Heat of Fusion");
        baseGraph.yGranularity = 2.5f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "W/cmK", -1.0f, "1st Ionization Potential");
        baseGraph.yGranularity = 1.0f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "W/cmK", -1.0f, "2nd Ionization Potential");
        baseGraph.yGranularity = 5.0f;
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        loadStatusManager.setProgress("Created 40 graphs...");
        baseGraph = new BaseGraph(n++, this, propertyPanelManager, configManager, databaseManager, statusBar, "W/cmK", -1.0f, "3rd Ionization Potential");
        propertyPanelManager.addPropertyPanel(graph, baseGraph, baseGraph);
        loadStatusManager.setProgress("Selecting Hydrogen...");
        propertyPanelManager.setAtom(1);
    }

    public float getGraphData(int n, TElement tElement) {
        switch (n) {
            case 0: {
                return tElement.Mass;
            }
            case 1: {
                return tElement.Melting;
            }
            case 2: {
                return tElement.Boiling;
            }
            case 3: {
                return tElement.Density;
            }
            case 4: {
                return tElement.SpecificHeat;
            }
            case 5: {
                return tElement.Ionization;
            }
            case 6: {
                return tElement.Vaporization;
            }
            case 7: {
                return tElement.AtomicRadii;
            }
            case 8: {
                return tElement.Frequency;
            }
            case 9: {
                return tElement.Electronegativity;
            }
            case 10: {
                return tElement.Sanderson;
            }
            case 11: {
                return tElement.Rochow;
            }
            case 12: {
                return tElement.Mulliken;
            }
            case 13: {
                return tElement.Allen;
            }
            case 14: {
                return tElement.gperkg;
            }
            case 15: {
                return tElement.affinity;
            }
            case 16: {
                return tElement.molar_volume;
            }
            case 17: {
                return tElement.sound_velocity;
            }
            case 18: {
                return tElement.ohms;
            }
            case 19: {
                return tElement.UniverseByWeight;
            }
            case 20: {
                return tElement.UniverseByAtom;
            }
            case 21: {
                return tElement.SunByWeight;
            }
            case 22: {
                return tElement.SunByAtom;
            }
            case 23: {
                return tElement.MeteoritesByWeight;
            }
            case 24: {
                return tElement.MeteoritesByAtom;
            }
            case 25: {
                return tElement.CrustalRocksByWeight;
            }
            case 26: {
                return tElement.CrustalRocksByAtom;
            }
            case 27: {
                return tElement.SeaWaterByWeight;
            }
            case 28: {
                return tElement.SeaWaterByAtom;
            }
            case 29: {
                return tElement.StreamByWeight;
            }
            case 30: {
                return tElement.SeaWaterByAtom;
            }
            case 31: {
                return tElement.HumanByWeight;
            }
            case 32: {
                return tElement.HumanByAtom;
            }
            case 33: {
                return tElement.CovalentRadius;
            }
            case 34: {
                return tElement.AtomicVol;
            }
            case 35: {
                return tElement.HVaporization;
            }
            case 36: {
                return tElement.ThermConductivity;
            }
            case 37: {
                return tElement.HFusion;
            }
            case 38: {
                return tElement.PIonPotent;
            }
            case 39: {
                return tElement.SIonPotent;
            }
            case 40: {
                return tElement.TIonPotent;
            }
        }
        throw new IllegalArgumentException("PropertyPanelScript.getGraphData: index is not within the range 0-9!");
    }

    public String getTextPanelData(int n, TElement tElement) {
        switch (n) {
            case 0: {
                return tElement.ElectronConfig;
            }
            case 1: {
                return tElement.HalfLife;
            }
            case 2: {
                return tElement.hazards;
            }
            case 3: {
                return tElement.abundances;
            }
            case 4: {
                return tElement.CASRegistry;
            }
            case 5: {
                return tElement.Crystal;
            }
        }
        throw new IllegalArgumentException("PropertyPanelScript.getTextPanelData: index is not within the range 0-5!");
    }

    public String getHtmlPanelData(int n, TElement tElement) {
        switch (n) {
            case 0: {
                return "NameInfo/" + tElement.Name + ".html";
            }
        }
        throw new IllegalArgumentException("PropertyPanelScript.getHtmlPanelData: index is not within the range 0-0!");
    }

    PropertyPanelScript() {
    }
}

