import java.io.*;
import java.net.URL;

public class IOManager {
   private boolean isApp;
   private String sCodeBase;

   public IOManager(ConfigManager cfgmgr) {
       isApp = cfgmgr.isApp();
       sCodeBase = cfgmgr.getCodeBase();
   }

   public InputStream getInputStream(String string) throws IOException{
   	InputStream res = null;
   	try {
   		res = getClass().getResourceAsStream(string);
       } catch (SecurityException e) {
       	if(isApp) {
           	return new FileInputStream(string);
       	} else {//is applet
           	return new URL(sCodeBase + string).openStream();
       	}
       }
       return res;
   }

   public byte[] getFile(String fname) throws IOException {
       InputStream is = getInputStream(fname);
       byte[] b = new byte[is.available()];
       is.read(b);
       return b;
   }
}