import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class JComponentDialog extends JDialog implements ActionListener {
   public JComponentDialog(Frame parent, String title, Component c, ActionListener a, String btns[]) {
       super(parent, title, true);

       Container cc = getContentPane();
       cc.setLayout(new BorderLayout());
       cc.add("Center", c);

       JPanel p = new JPanel();
       JButton b = new JButton("OK");
       b.setActionCommand("OK");
       b.addActionListener(this);
       p.add(b);

       for(int i = 0;i<btns.length;i++) {
           b = new JButton(btns[i]);
           b.setActionCommand(btns[i]);
           b.addActionListener(a);
           p.add(b);
       }

       cc.add("South", p);

//       setResizable(false);
       Dimension d = c.getPreferredSize();
       d.height += p.getPreferredSize().height;

       d.width *= 1.2;
       d.height *= 1.2;

       pack();
       show();
       d = Toolkit.getDefaultToolkit().getScreenSize();
       Dimension bb = getSize();
       setLocation((d.width - bb.width) / 2, (d.height - bb.height) / 2);
   }

   public void actionPerformed(ActionEvent e) {
       if(e.getActionCommand().equals("OK")) {
           dispose();
       }
   }
}