package grid.manager;

import grid.util.Defaults;
import java.awt.BorderLayout;
import javax.swing.JFrame;
import java.rmi.Naming;
import java.rmi.registry.Registry;
import java.rmi.registry.LocateRegistry;

public class App extends JFrame {
	public static void main(String args[]) {
		String name = "//./"+Defaults.managerService;

		//set up manager
		System.setSecurityManager(new java.rmi.RMISecurityManager());

		Manager man = null;
		try {
			man = new Manager();
		} catch (Exception e) {
			System.err.println("Unable to create manager.");
			e.printStackTrace();
			return;
		}

		//try to bind manager
		try {
			Naming.rebind(name, man);
			System.out.println("Bound manager as "+name);
		} catch (Exception e) {
			//if a bad thing happens (except connect failure), abort
			if(!(e instanceof java.rmi.ConnectException)) {
				if(e instanceof java.security.AccessControlException) {
					System.err.println("Connecting to port 1099 was disallowed. "
						+ "Did you forget -Djava.security.policy= ?");
					return;
				}
				e.printStackTrace();
				return;
			}

			//if the problem was that we couldn't connect to the RMI
			//registry, try creating a registry and rebinding.
			try {
				Registry registry = LocateRegistry.createRegistry(1099);
			} catch (Exception x) {
				System.err.println("Unable to connect to or create a registry!");
				x.printStackTrace();
				return;
			}

			//now rebind.
			try {
				Naming.rebind(name, man);
				System.out.println("Bound manager as "+name);
			} catch (Exception f) {
				System.err.println("Still can't bind.  Aborting.");
				f.printStackTrace();
				return;
			}
		}

		//now create UI.
		App a = new App(man);
		a.setVisible(true);
	}

	public App(Manager man) {
		super(Defaults.version+" Job Manager");

		//set up UI
		JobController jc = new JobController(man, this);
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(jc, BorderLayout.CENTER);
		addWindowListener(jc);
		setSize(640, 480);
	}
}
