/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class AllElementInfo
extends JScrollPane
implements ActionListener,
IPanelListener {
    private Hashtable elements;
    private Hashtable types;
    private Hashtable classes;
    private Hashtable states;
    private PropertyPanelManager ppmgr;
    private DatabaseManager dbmgr;
    private ConfigManager cfgmgr;
    private JTable j = new JTable();
    private JMenuItem miCopyToClipboard = new JMenuItem("Copy to Clipboard...", 67);
    private JMenuItem miPrintGraph = new JMenuItem("Print Text...", 80);
    private JMenu pmContext = new JCoolMenu("Panel");
    private int currSelection = -1;
    Object[][] data;
    TableModel dataModel = new AbstractTableModel(){
        final String[] names = new String[]{"Property", "Value"};

        public int getColumnCount() {
            return this.names.length;
        }

        public int getRowCount() {
            return AllElementInfo.this.data.length;
        }

        public Object getValueAt(int n, int n2) {
            return AllElementInfo.this.data[n][n2];
        }

        public String getColumnName(int n) {
            return this.names[n];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    };
    private static final int NUM_CLASSES = 73;
    private static final String[] categories = new String[]{"Name", "Atomic Number", "Symbol", "Element Type", "State", "Mass (amu)", "Relative Mass", "Melts at (K)", "Boils at (K)", "Valency", "Discovery Date", "Discoverer", "Name Origin", "Uses", "Obtained From", "Electron Config", "Electronegativity", "Density (g/cm^3)", "Ionization Energy (eV)", "Specific Heat (cal/g K)", "Vaporization (Kcal / g*atom)", "Atomic Radii (ang)", "Class Type", "Sanderson Electronegativity", "Rochow Electronegativity", "Mulliken Electronegativity", "Allen Electronegativity", "g of element / kg of human", "Zeff for 1s", "Zeff for 2s", "Zeff for 2p", "Zeff for 3s", "Zeff for 3p", "Zeff for 3d", "Zeff for 4s", "Zeff for 4p", "Zeff for 4d", "Zeff for 4f", "Zeff for 5s", "Zeff for 5p", "Zeff for 5d", "Zeff for 6s", "Zeff for 6p", "Zeff for 7s", "Electron Affinity (kJ/mol)", "Molar Volume (cm^3)", "Resistivity (u-ohms)", "Abundances", "Hazards", "Universe (ppb by Weight)", "Universe (ppb by Atom)", "Sun (ppb by Weight)", "Sun (ppb by Atom)", "Meteorites (ppb by Weight)", "Meteorites (ppb by Atom)", "CrustalRocks (ppb by Weight)", "CrustalRocks (ppb by Atom)", "SeaWater (ppb by Weight)", "SeaWater (ppb by Atom)", "Stream (ppb by Weight)", "Stream (ppb by Atom)", "Human (ppb by Weight)", "Human (ppb by Atom)", "Covalent Radius (\ufffd)", "CAS Registry Number", "Crystal Structure", "Atomic Volume (cm^3/mol)", "Heat of Vaporization (kJ/mol)", "Thermal Conductivity (W/cmK)", "Heat of Fusion (kJ/mol)", "1st Ion Potential (V)", "2nd Ion Potential (V)", "3rd Ion Potential (V)", ""};

    public AllElementInfo(PropertyPanelManager propertyPanelManager, DatabaseManager databaseManager, ConfigManager configManager) {
        this.dbmgr = databaseManager;
        this.ppmgr = propertyPanelManager;
        this.cfgmgr = configManager;
        this.elements = this.dbmgr.getElements();
        this.types = this.dbmgr.getTypes();
        this.classes = this.dbmgr.getClasses();
        this.states = this.dbmgr.getStates();
        Font font = this.j.getFont();
        this.j.setFont(new Font(font.getName(), 0, 20));
        this.j.setRowHeight(this.j.getRowHeight() + 10);
        this.j.setSelectionMode(0);
        this.setViewportView(this.j);
        this.j.setCellSelectionEnabled(false);
        if (this.cfgmgr.canGetClipboard()) {
            this.miCopyToClipboard.addActionListener(this);
            this.miCopyToClipboard.setActionCommand("CopyToClipboard");
            this.pmContext.add(this.miCopyToClipboard);
        }
        if (this.cfgmgr.canPrint()) {
            this.miPrintGraph.addActionListener(this);
            this.miPrintGraph.setActionCommand("FilePrintTable");
            this.pmContext.add(this.miPrintGraph);
        }
        this.pmContext.setMnemonic('P');
    }

    public void setAtom(PanelEvent panelEvent) {
        TElement tElement = panelEvent.getElement();
        Object[][] objectArray = new Object[73][2];
        for (int i = 0; i < 73; ++i) {
            objectArray[i][0] = AllElementInfo.getCategories(i);
            objectArray[i][1] = AllElementInfo.retrieveData(tElement, i, this.dbmgr);
        }
        this.data = objectArray;
        this.j.setModel(this.dataModel);
        this.j.repaint();
        this.currSelection = tElement.AtomicNumber;
    }

    public void onActivate(PanelEvent panelEvent) {
        this.ppmgr.addMenu(this.pmContext);
    }

    public void onDeactivate(PanelEvent panelEvent) {
        this.ppmgr.removeMenu(this.pmContext);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("CopyToClipboard")) {
            this.OnCopyToClipboard();
        } else if (string.equals("FilePrintTable")) {
            this.OnFilePrintTable();
        }
    }

    private void OnCopyToClipboard() {
        StringSelection stringSelection = new StringSelection(AllElementInfo.getAtomInfoAsText(this.currSelection, this.dbmgr));
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    public static String getAtomInfoAsText(int n, DatabaseManager databaseManager) {
        return AllElementInfo.getAtomInfoAsText((TElement)databaseManager.getElements().get(new Integer(n)), databaseManager);
    }

    public static String getAtomInfoAsText(TElement tElement, DatabaseManager databaseManager) {
        if (tElement == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 73; ++i) {
            stringBuffer.append(AllElementInfo.getCategories(i));
            stringBuffer.append("\t\t");
            stringBuffer.append(AllElementInfo.retrieveData(tElement, i, databaseManager));
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    private static String retrieveData(TElement tElement, int n, DatabaseManager databaseManager) {
        switch (n) {
            case 0: {
                return tElement.Name;
            }
            case 1: {
                return Integer.toString(tElement.AtomicNumber);
            }
            case 2: {
                return tElement.Symbol;
            }
            case 3: {
                return TElementType.getTypeName(tElement.ElementType, databaseManager.getTypes());
            }
            case 4: {
                return TState.getStateName(tElement.State, databaseManager.getStates());
            }
            case 5: {
                return Float.toString(tElement.Mass);
            }
            case 6: {
                return Integer.toString(tElement.RelativeMass);
            }
            case 7: {
                return AllElementInfo.procFloat(tElement.Melting);
            }
            case 8: {
                return AllElementInfo.procFloat(tElement.Boiling);
            }
            case 9: {
                return tElement.Valency;
            }
            case 10: {
                return tElement.DateDiscovered == 0 ? "Ancient" : Integer.toString(tElement.DateDiscovered);
            }
            case 11: {
                return tElement.Discoverer;
            }
            case 12: {
                return tElement.NameOrigin;
            }
            case 13: {
                return tElement.Uses;
            }
            case 14: {
                return tElement.ObtainedFrom;
            }
            case 15: {
                return tElement.ElectronConfig;
            }
            case 16: {
                return AllElementInfo.procFloat(tElement.Electronegativity);
            }
            case 17: {
                return AllElementInfo.procFloat(tElement.Density);
            }
            case 18: {
                return AllElementInfo.procFloat(tElement.Ionization);
            }
            case 19: {
                return AllElementInfo.procFloat(tElement.SpecificHeat);
            }
            case 20: {
                return AllElementInfo.procFloat(tElement.Vaporization);
            }
            case 21: {
                return AllElementInfo.procFloat(tElement.AtomicRadii);
            }
            case 22: {
                return TClass.getClassName(tElement.ClassType, databaseManager.getClasses());
            }
            case 23: {
                return AllElementInfo.procFloat(tElement.Sanderson);
            }
            case 24: {
                return AllElementInfo.procFloat(tElement.Rochow);
            }
            case 25: {
                return AllElementInfo.procFloat(tElement.Mulliken);
            }
            case 26: {
                return AllElementInfo.procFloat(tElement.Allen);
            }
            case 27: {
                return Float.toString(tElement.gperkg);
            }
            case 28: {
                return AllElementInfo.procFloat(tElement.zeff_s1);
            }
            case 29: {
                return AllElementInfo.procFloat(tElement.zeff_s2);
            }
            case 30: {
                return AllElementInfo.procFloat(tElement.zeff_p2);
            }
            case 31: {
                return AllElementInfo.procFloat(tElement.zeff_s3);
            }
            case 32: {
                return AllElementInfo.procFloat(tElement.zeff_p3);
            }
            case 33: {
                return AllElementInfo.procFloat(tElement.zeff_d3);
            }
            case 34: {
                return AllElementInfo.procFloat(tElement.zeff_s4);
            }
            case 35: {
                return AllElementInfo.procFloat(tElement.zeff_p4);
            }
            case 36: {
                return AllElementInfo.procFloat(tElement.zeff_d4);
            }
            case 37: {
                return AllElementInfo.procFloat(tElement.zeff_f4);
            }
            case 38: {
                return AllElementInfo.procFloat(tElement.zeff_s5);
            }
            case 39: {
                return AllElementInfo.procFloat(tElement.zeff_p5);
            }
            case 40: {
                return AllElementInfo.procFloat(tElement.zeff_d5);
            }
            case 41: {
                return AllElementInfo.procFloat(tElement.zeff_s6);
            }
            case 42: {
                return AllElementInfo.procFloat(tElement.zeff_p6);
            }
            case 43: {
                return AllElementInfo.procFloat(tElement.zeff_s7);
            }
            case 44: {
                return AllElementInfo.procFloat(tElement.affinity);
            }
            case 45: {
                return AllElementInfo.procFloat(tElement.molar_volume);
            }
            case 46: {
                return AllElementInfo.procFloat(tElement.sound_velocity);
            }
            case 47: {
                return tElement.abundances;
            }
            case 48: {
                return tElement.hazards;
            }
            case 49: {
                return AllElementInfo.procFloat(tElement.UniverseByWeight);
            }
            case 50: {
                return AllElementInfo.procFloat(tElement.UniverseByAtom);
            }
            case 51: {
                return AllElementInfo.procFloat(tElement.SunByWeight);
            }
            case 52: {
                return AllElementInfo.procFloat(tElement.SunByAtom);
            }
            case 53: {
                return AllElementInfo.procFloat(tElement.MeteoritesByWeight);
            }
            case 54: {
                return AllElementInfo.procFloat(tElement.MeteoritesByAtom);
            }
            case 55: {
                return AllElementInfo.procFloat(tElement.CrustalRocksByWeight);
            }
            case 56: {
                return AllElementInfo.procFloat(tElement.CrustalRocksByAtom);
            }
            case 57: {
                return AllElementInfo.procFloat(tElement.SeaWaterByWeight);
            }
            case 58: {
                return AllElementInfo.procFloat(tElement.SeaWaterByAtom);
            }
            case 59: {
                return AllElementInfo.procFloat(tElement.StreamByWeight);
            }
            case 60: {
                return AllElementInfo.procFloat(tElement.StreamByAtom);
            }
            case 61: {
                return AllElementInfo.procFloat(tElement.HumanByWeight);
            }
            case 62: {
                return AllElementInfo.procFloat(tElement.HumanByAtom);
            }
            case 63: {
                return AllElementInfo.procFloat(tElement.CovalentRadius);
            }
            case 64: {
                return tElement.CASRegistry;
            }
            case 65: {
                return tElement.Crystal;
            }
            case 66: {
                return AllElementInfo.procFloat(tElement.AtomicVol);
            }
            case 67: {
                return AllElementInfo.procFloat(tElement.HVaporization);
            }
            case 68: {
                return AllElementInfo.procFloat(tElement.ThermConductivity);
            }
            case 69: {
                return AllElementInfo.procFloat(tElement.HFusion);
            }
            case 70: {
                return AllElementInfo.procFloat(tElement.PIonPotent);
            }
            case 71: {
                return AllElementInfo.procFloat(tElement.SIonPotent);
            }
            case 72: {
                return AllElementInfo.procFloat(tElement.TIonPotent);
            }
        }
        throw new IllegalArgumentException("Categories range from 0 to 72.");
    }

    private static String procFloat(float f) {
        return (double)f == -1.0 ? "Unknown" : Float.toString(f);
    }

    private static String getCategories(int n) {
        if (n < 0 || n >= 73) {
            throw new IllegalArgumentException("Categories range from 0 to 72.");
        }
        return categories[n];
    }

    private void OnFilePrintTable() {
    }

    public String toString() {
        return "All Properties";
    }

    public void setStyle(PanelEvent panelEvent) {
    }

    public void updateUI() {
        super.updateUI();
        if (this.pmContext != null) {
            this.pmContext.updateUI();
        }
    }
}

