/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AtomAni
extends JPanel
implements IPanelListener,
Runnable,
ActionListener,
ChangeListener {
    public atom model;
    private JButton start = new JButton("Start");
    private JButton stop = new JButton("Stop");
    private JSlider speed = new JSlider(0, 2000, 500);
    private JLabel lSpeed = new JLabel("500ms");
    private Thread t;
    private Image iBuffer;
    private int delay = 500;
    private int radius;
    private boolean killNow = false;

    public String toString() {
        return "Electron Animation";
    }

    public AtomAni() {
        this.setLayout(new FlowLayout(0));
        this.add(this.start);
        this.start.addActionListener(this);
        this.add(this.stop);
        this.stop.addActionListener(this);
        this.add(this.lSpeed);
        this.add(this.speed);
        this.speed.addChangeListener(this);
        this.lSpeed.setForeground(Color.white);
        this.setBackground(Color.black);
        int n = Math.min(this.getSize().width, this.getSize().height);
        this.model = new atom(1, 1, n, n);
        this.startDraw();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.delay = this.speed.getValue();
        this.lSpeed.setText(this.delay + "ms");
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        int n = Math.min(dimension.width, dimension.height);
        if (this.iBuffer == null || this.radius != n) {
            this.iBuffer = this.createImage(n, n);
            int n2 = this.model.AtomicNumber;
            this.model = new atom(n2, n2, n, n);
            this.radius = n;
        }
        Graphics graphics2 = this.iBuffer.getGraphics();
        graphics2.setColor(Color.black);
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        graphics2.setColor(Color.white);
        this.model.draw(graphics2, n / 2, n / 2);
        graphics.drawImage(this.iBuffer, dimension.width - n, (dimension.height - n) / 2, null, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.start) {
            this.startDraw();
        } else if (actionEvent.getSource() == this.stop) {
            this.stopDraw();
        }
    }

    public void run() {
        while (!this.killNow) {
            this.repaint();
            try {
                Thread.sleep(this.delay);
            }
            catch (Exception exception) {
            }
        }
        return;
    }

    public void setAtom(PanelEvent panelEvent) {
        this.model.setAtomicNumber(panelEvent.getElement().AtomicNumber);
    }

    public void onActivate(PanelEvent panelEvent) {
        this.startDraw();
    }

    public void onDeactivate(PanelEvent panelEvent) {
        this.stopDraw();
    }

    private void startDraw() {
        this.killNow = false;
        this.t = new Thread(this);
        this.t.setDaemon(true);
        this.t.start();
    }

    private void stopDraw() {
        this.killNow = true;
    }

    public void setStyle(PanelEvent panelEvent) {
    }
}

