/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;

class Electron {
    int max = 1;
    int actual = 0;
    double radius = 100.0;
    double[] angles = null;
    double d_angles = 1.0;
    int[] x = null;
    int[] y = null;
    int electron_size;
    int first = 1;
    atom parent;

    Electron(atom atom2, int n, double d, double d2) {
        this.parent = atom2;
        this.max = n;
        this.angles = new double[this.max];
        this.x = new int[this.max];
        this.y = new int[this.max];
        for (int i = 0; i < this.max; ++i) {
            this.angles[i] = d;
            this.d_angles = d2 * (1.0 + 0.2 * Math.random());
        }
    }

    public void move() {
        for (int i = 0; i < this.max; ++i) {
            int n = i;
            this.angles[n] = this.angles[n] + this.d_angles;
            this.x[i] = (int)(this.radius * Math.cos(this.angles[i]));
            this.y[i] = (int)(this.radius * Math.sin(this.angles[i]));
        }
    }

    public void draw(Graphics2D graphics2D, int n, int n2) {
        n -= this.electron_size / 2;
        n2 -= this.electron_size / 2;
        if (this.first > 0) {
            this.move();
            this.first = 0;
        }
        if (this.parent.start > 0) {
            this.move();
            this.first = 0;
        }
        for (int i = 0; i < this.actual; ++i) {
            graphics2D.setColor(Color.blue);
            graphics2D.fill(new Ellipse2D.Double(n + this.x[i], n2 + this.y[i], this.electron_size, this.electron_size));
            graphics2D.setColor(Color.white);
        }
    }

    public void set_settings(double d, int n) {
        this.radius = d;
        this.electron_size = n;
        for (int i = 0; i < this.max; ++i) {
            int n2 = i;
            this.angles[n2] = this.angles[n2] + (double)i * Math.PI * 2.0 / (double)this.actual;
        }
    }
}

