/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class MenuManager
implements ActionListener {
    private ConfigManager cfgmgr;
    private LoadStatusManager lsmgr;
    private JMenuBar jmb = null;
    private JPeriod99 parent;
    private PropertyPanelManager ppmgr;
    private JMenuBar mb;
    private int style = 14;
    private JMenuItem miFileSaveElement = new JMenuItem("Save Element...", 83);
    private JMenuItem miFileSaveAll = new JMenuItem("Save All Elements...", 65);
    private JMenuItem miFileSaveDatabase = new JMenuItem("Save Database...", 68);
    private JMenuItem miFilePrintEverything = new JMenuItem("Print Everything...", 69);
    private JMenuItem miFileExit = new JMenuItem("Exit", 120);
    private JMenuItem miHelpAbout = new JMenuItem("About...", 65);
    private JMenuItem miHelpAboutVM = new JMenuItem("About Java VM...", 86);
    private JCheckBoxMenuItem cmiGraphsInterpolate = new JCheckBoxMenuItem("Interpolate Missing Points", false);
    private JCheckBoxMenuItem cmiGraphsDrawLocator = new JCheckBoxMenuItem("Draw Locator", true);
    private JCheckBoxMenuItem cmiGraphsFollowCurve = new JCheckBoxMenuItem("Locator Follows Curve", true);
    private JCheckBoxMenuItem cmiOpaqueCoords = new JCheckBoxMenuItem("Opaque Coordinates", true);
    private JCheckBoxMenuItem cmiTableOnForm = new JCheckBoxMenuItem("Table on Main Window", true);
    private JCheckBoxMenuItem cmiPropListOnForm = new JCheckBoxMenuItem("Property List on Main Window", true);
    private JRadioButtonMenuItem rmiColorsColor = new JRadioButtonMenuItem("Color", true);
    private JRadioButtonMenuItem rmiColorsMono = new JRadioButtonMenuItem("Monochrome", false);
    private JCoolMenu mFile = new JCoolMenu("File");
    private JCoolMenu mColors = new JCoolMenu("Colors");
    private JCoolMenu mAppearance = new JCoolMenu("Appearance");
    private JCoolMenu mGraphs = new JCoolMenu("Graphs");
    private JCoolMenu mTable = new JCoolMenu("Table");
    private JCoolMenu mHelp = new JCoolMenu("Help");

    public MenuManager(LoadStatusManager loadStatusManager, ConfigManager configManager, JPeriod99 jPeriod99, PropertyPanelManager propertyPanelManager) {
        this.cfgmgr = configManager;
        this.lsmgr = loadStatusManager;
        this.parent = jPeriod99;
        this.ppmgr = propertyPanelManager;
    }

    private void initMenuItem(JCoolMenu jCoolMenu, JMenuItem jMenuItem, char c, String string) {
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string);
        jMenuItem.setMnemonic(c);
        jCoolMenu.add(jMenuItem);
    }

    private JMenuBar initMenus() {
        this.lsmgr.setProgress("Creating \"File\" menu...");
        if (this.cfgmgr.canWriteFiles()) {
            this.initMenuItem(this.mFile, this.miFileSaveElement, 'S', "FileSave");
            this.initMenuItem(this.mFile, this.miFileSaveAll, 'A', "FileSaveAll");
            this.initMenuItem(this.mFile, this.miFileSaveDatabase, 'D', "FileSaveDBase");
        }
        this.mFile.add(new JSeparator());
        if (this.cfgmgr.canPrint()) {
            this.initMenuItem(this.mFile, this.miFilePrintEverything, 'E', "FilePrintEverything");
        }
        if (!this.cfgmgr.canExitVM()) {
            this.miFileExit.setText("Close");
            this.miFileExit.setMnemonic('C');
        }
        this.miFileExit.addActionListener(this);
        this.miFileExit.setActionCommand("FileExit");
        this.mFile.add(this.miFileExit);
        this.mFile.setMnemonic('F');
        this.lsmgr.setProgress("Creating \"Colors\" menu...");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.initMenuItem(this.mColors, this.rmiColorsColor, 'C', "ColorsColor");
        buttonGroup.add(this.rmiColorsColor);
        this.initMenuItem(this.mColors, this.rmiColorsMono, 'M', "ColorsMono");
        buttonGroup.add(this.rmiColorsMono);
        this.lsmgr.setProgress("Creating \"Appearance\" menu...");
        this.mAppearance.setMnemonic('A');
        buttonGroup = new ButtonGroup();
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        boolean bl = false;
        try {
            this.getClass();
            Class.forName("javax.swing.plaf.mac.MacLookAndFeel");
            UIManager.installLookAndFeel("Macintosh", "javax.swing.plaf.mac.MacLookAndFeel");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!bl) {
            try {
                this.getClass();
                Class.forName("com.sun.java.swing.plaf.mac.MacLookAndFeel");
                UIManager.installLookAndFeel("Macintosh", "com.sun.java.swing.plaf.mac.MacLookAndFeel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(lookAndFeelInfoArray[i].getName(), lookAndFeel.getName().equals(lookAndFeelInfoArray[i].getName()));
            jRadioButtonMenuItem.addActionListener(this);
            jRadioButtonMenuItem.setActionCommand(lookAndFeelInfoArray[i].getClassName());
            buttonGroup.add(jRadioButtonMenuItem);
            this.mAppearance.add(jRadioButtonMenuItem);
        }
        this.mColors.setMnemonic('C');
        this.lsmgr.setProgress("Creating \"Graphs\" menu...");
        this.initMenuItem(this.mGraphs, this.cmiGraphsInterpolate, 'I', "GraphsInterpolate");
        this.initMenuItem(this.mGraphs, this.cmiGraphsDrawLocator, 'L', "GraphsDrawLocator");
        this.initMenuItem(this.mGraphs, this.cmiGraphsFollowCurve, 'F', "GraphsFollowCurve");
        this.initMenuItem(this.mGraphs, this.cmiOpaqueCoords, 'O', "OpaqueCoords");
        this.mGraphs.setMnemonic('G');
        this.lsmgr.setProgress("Creating \"Table\" menu...");
        this.initMenuItem(this.mTable, this.cmiTableOnForm, 'T', "AtomicTableOnForm");
        this.initMenuItem(this.mTable, this.cmiPropListOnForm, 'P', "PropTreeOnForm");
        this.mTable.setMnemonic('T');
        this.lsmgr.setProgress("Creating \"Help\" menu...");
        this.initMenuItem(this.mHelp, this.miHelpAboutVM, 'V', "HelpAboutVM");
        this.initMenuItem(this.mHelp, this.miHelpAbout, 'A', "HelpAbout");
        this.mHelp.setMnemonic('H');
        this.mb = new JMenuBar();
        this.mb.add(this.mFile);
        this.mb.add(this.mAppearance);
        this.mb.add(this.mGraphs);
        this.mb.add(this.mTable);
        this.mb.add(this.mHelp);
        this.mb.setBorder(null);
        return this.mb;
    }

    public JMenuBar getMenuBar() {
        if (this.jmb == null) {
            this.jmb = this.initMenus();
        }
        return this.jmb;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("FileSave")) {
            this.parent.OnFileSave();
        } else if (string.equals("FileSaveAll")) {
            this.parent.OnFileSaveAll();
        } else if (string.equals("FileSaveDBase")) {
            this.parent.OnFileSaveDatabase();
        } else if (string.equals("FilePrintEverything")) {
            this.parent.OnFilePrintEverything();
        } else if (string.equals("FileExit")) {
            this.parent.dispose();
            if (this.cfgmgr.canExitVM()) {
                System.exit(0);
            } else {
                this.parent.makeWindowEvent(new WindowEvent(this.parent, 201));
            }
        } else if (!string.equals("ColorsColor") && !string.equals("ColorsMono")) {
            if (string.equals("GraphsInterpolate")) {
                JCheckBoxMenuItem jCheckBoxMenuItem = this.cmiGraphsInterpolate;
                this.style = jCheckBoxMenuItem.isSelected() ? (this.style |= 1) : (this.style &= 0xFFFFFFFE);
                this.ppmgr.setStyle(this.style);
            } else if (string.equals("GraphsDrawLocator")) {
                JCheckBoxMenuItem jCheckBoxMenuItem = this.cmiGraphsDrawLocator;
                this.style = jCheckBoxMenuItem.isSelected() ? (this.style |= 2) : (this.style &= 0xFFFFFFFD);
                this.ppmgr.setStyle(this.style);
            } else if (string.equals("GraphsFollowCurve")) {
                JCheckBoxMenuItem jCheckBoxMenuItem = this.cmiGraphsFollowCurve;
                this.style = jCheckBoxMenuItem.isSelected() ? (this.style |= 4) : (this.style &= 0xFFFFFFFB);
                this.ppmgr.setStyle(this.style);
            } else if (string.equals("OpaqueCoords")) {
                JCheckBoxMenuItem jCheckBoxMenuItem = this.cmiOpaqueCoords;
                this.style = jCheckBoxMenuItem.isSelected() ? (this.style |= 8) : (this.style &= 0xFFFFFFF7);
                this.ppmgr.setStyle(this.style);
            } else if (string.equals("PropTreeOnForm")) {
                JCheckBoxMenuItem jCheckBoxMenuItem = this.cmiPropListOnForm;
                if (actionEvent.getSource() != jCheckBoxMenuItem) {
                    jCheckBoxMenuItem.setSelected(!jCheckBoxMenuItem.isSelected());
                }
                this.parent.toggleTreeOnForm(jCheckBoxMenuItem.isSelected());
            } else if (string.equals("AtomicTableOnForm")) {
                JCheckBoxMenuItem jCheckBoxMenuItem = this.cmiTableOnForm;
                if (actionEvent.getSource() != jCheckBoxMenuItem) {
                    jCheckBoxMenuItem.setSelected(!jCheckBoxMenuItem.isSelected());
                }
                this.parent.toggleTableOnForm(jCheckBoxMenuItem.isSelected());
            } else if (string.equals("HelpAboutVM")) {
                this.parent.OnHelpAboutVM();
            } else if (string.equals("HelpAbout")) {
                this.parent.OnHelpAbout();
            } else if (string.indexOf(46) > -1) {
                try {
                    UIManager.setLookAndFeel(string);
                    SwingUtilities.updateComponentTreeUI(this.parent);
                    this.ppmgr.updateComponentTreeUI();
                    SwingUtilities.updateComponentTreeUI(this.mb);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }
}

