import javax.swing.*;
import javax.swing.filechooser.*;
import java.io.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.util.*;

public class BaseGraph extends JComponent implements IPanelListener, ActionListener, MouseListener, MouseMotionListener {
   public static final Color darkGreen = new Color(0,48,0);
   public static final Color lightGreen = new Color(0, 255, 0);
   public static final Color lightBlue = new Color(0, 0, 255);

   private PropertyPanelScript script;
   private PropertyPanelManager ppmgr;
   private Hashtable elements;
   private int index;
   private StatusBar sbb;

   private int minElement = Integer.MAX_VALUE, maxElement = Integer.MIN_VALUE;
   private float stepX = 1;
   private float minY = Float.MAX_VALUE, maxY = Float.MIN_VALUE;
   private float stepY = 1;

   private int selectedAtom = -1;
   private String units;
   private int X=0, Y=0;
   private float gridX = 0, gridY = 0;

   public Color labelColor = Color.white;
   public float invalid = 0;
   public Color gridColor = darkGreen;
   public Color locatorColor = lightBlue;
   public float yGranularity = 10;
   public Color axisColor = Color.white;
   public Color selectedColor = Color.red;
   public Color curveColor = lightGreen;
   public int yLowerMargin = 30;
   public int xLeftMargin = 50;
   public int yCaptionGranularity = 5;
   public int xCaptionGranularity = 10;
   public int yTopMargin = 10;
   public Color locatorCaption = Color.black;
   public int yCaptionLength = 5;

   private Dimension oldD = new Dimension(0, 0);

   private boolean bInterpolateMissing = false;
   private boolean bDrawLocator = true;
   private boolean bLocatorFollowCurve = true;
   private boolean bOpaqueCoords = true;

   private boolean activated = false;
   private JMenuItem miSaveGraphToFile = new JMenuItem("Save Graph Image...", 'S');
   private JMenuItem miPrintGraph = new JMenuItem("Print Graph Image...", 'P');
   private JMenu pmContext = new JCoolMenu("Panel");

   private boolean mustRepaint = false;

   public int getMinElement(){return minElement;}
   public int getMaxElement(){return maxElement;}

   private String caption = "";

   public BaseGraph (int idx, PropertyPanelScript pps, PropertyPanelManager pp, ConfigManager cfgmgr, DatabaseManager dbmgr, StatusBar sb, String unts, float inv, String c){
       caption = c;
       invalid = inv;
       units = unts;
       script = pps;
       ppmgr = pp;
       elements = dbmgr.getElements();
       index = idx;
       sbb = sb;

       Enumeration itr = elements.elements();
       int i;

       while(itr.hasMoreElements()) {
           TElement e = (TElement)itr.nextElement();
           i = e.AtomicNumber;
           if(i < minElement) minElement = i;
           if(i > maxElement) maxElement = i;

           float ff = script.getGraphData(index, e);
           if(ff == invalid) continue;
           if(ff < minY) minY = ff;
           if(ff > maxY) maxY = ff;
       }

       setBackground(Color.black);

       addMouseMotionListener(this);
       addMouseListener(this);

       if(cfgmgr.canWriteFiles()) {
           miSaveGraphToFile.addActionListener(this);
           miSaveGraphToFile.setActionCommand("FileSaveGraph");
           pmContext.add(miSaveGraphToFile);
       }

       if(cfgmgr.canPrint()) {
           miPrintGraph.addActionListener(this);
           miPrintGraph.setActionCommand("FilePrintGraph");
           pmContext.add(miPrintGraph);
       }
       pmContext.setMnemonic('P');
   }

   public void setAtom(PanelEvent pe){
       selectedAtom = pe.getElement().AtomicNumber;
       mustRepaint = true;
       if(activated == false) return;       
       repaint();
   }

   protected void paintBackground(Graphics g){
       Dimension d = getSize();
       g.setColor(getBackground());
       g.fillRect(0,0,d.width,d.height);
   }

   protected void paintGrid(Graphics g){
       Dimension d = getSize();
       float x=xLeftMargin, y=yLowerMargin;
       g.setColor(gridColor);

       //horz lines
       for(float f=minY;f<maxY;f += yGranularity){
           y = (   (maxY - f)  /  (maxY-minY)   ) * (d.height-yLowerMargin);
           g.drawLine(xLeftMargin-15, (int)(Math.round(y)), d.width, (int)(Math.round(y)) );
       }

       //vertical lines
       for(int i=minElement;i<=maxElement;i++){
           g.drawLine((int)(Math.round(x)),0,(int)(Math.round(x)),d.height-(yLowerMargin-15));
           x += stepX;
       }
   }

   protected void paintXAxis(Graphics g){
       Dimension d = getSize();
       float x=xLeftMargin,y=yLowerMargin;
       g.setColor(axisColor);
       g.drawLine(xLeftMargin-15,d.height-(yLowerMargin-15),d.width,d.height-(yLowerMargin-15));

       for(int i=minElement;i<=maxElement;i++){
           if((i%xCaptionGranularity)==0){
               g.drawLine((int)(Math.round(x)),d.height-(yLowerMargin-5),(int)(Math.round(x)),d.height);
               g.drawString(Integer.toString(i),(int)(Math.round(x)),d.height-3);
           } else if((i%5)==0){
               g.drawLine((int)(Math.round(x)),d.height-(yLowerMargin-7),(int)(Math.round(x)),d.height-(yLowerMargin-15));
           } else {
               g.drawLine((int)(Math.round(x)),d.height-(yLowerMargin-10),(int)(Math.round(x)),d.height-(yLowerMargin-15));
           }

           x += stepX;
       }
   }

   protected void paintYAxis(Graphics g){
       Dimension d = getSize();
       float x=xLeftMargin,y=yLowerMargin;
       g.setColor(axisColor);
       g.drawLine(xLeftMargin-15, yTopMargin, xLeftMargin-15, d.height-yLowerMargin+15);
       int i = 1;
       StringBuffer value;

       for(float f=minY;f<maxY;f += yGranularity){
           y = (   (maxY - f)  /  (maxY-minY)   ) * (d.height-yLowerMargin);
           if((i%yCaptionGranularity)==0){
               g.drawLine(0, (int)(Math.round(y)), xLeftMargin-5, (int)(Math.round(y)) );
               value = new StringBuffer(Float.toString(f));
               if(value.length() > yCaptionLength)
                   value.setLength(yCaptionLength);
               g.drawString(value.toString(), 3, (int)(Math.round(y))-5 );
           } else if((i%5)==0){
               g.drawLine(xLeftMargin-7, (int)(Math.round(y)), xLeftMargin-15, (int)(Math.round(y)) );
           } else {
               g.drawLine(xLeftMargin-10, (int)(Math.round(y)), xLeftMargin-15, (int)(Math.round(y)) );
           }

           i++;
       }
   }

   protected void paintLocator(Graphics g){
       Dimension d = getSize();
       if(!bDrawLocator) return;
       g.setColor(locatorColor);
       g.drawLine(X,0,X,d.height);
       g.drawLine(0,Y,d.width,Y);

       String yy = Float.toString(gridY);
       if(yy.length() > 5) yy = yy.substring(0,5);

       String xx = Float.toString(gridX);
       if(xx.length() > 5) xx = xx.substring(0,5);

       FontMetrics fm = g.getFontMetrics();
       String text = "("+xx+","+yy+")";
       Point p = checkVisible(text, fm, d, X+5, Y-5);

       int xpos = p.x;
       int ypos = p.y;

       //ideal:
       //g.fill3DRect(xpos-5, ypos - fm.getHeight() - 5, fm.stringWidth(text) + 10, fm.getHeight()+10, true);
       //real
       if(bOpaqueCoords) {
           g.setColor(new Color(0x66, 0x66, 0x99));
           g.drawRect(xpos, ypos - fm.getHeight()-5 , fm.stringWidth(text) + 10, fm.getHeight()+5);
           g.setColor(new Color(0xCC, 0xCC, 0xFF));
           g.fillRect(xpos+1, ypos - fm.getHeight()-4 , fm.stringWidth(text) + 9, fm.getHeight()+4);
           g.setColor(locatorCaption);
       }

       g.drawString(text, xpos+5, ypos-5);
   }

   private Point checkVisible(String text, FontMetrics fm, Dimension d, int xpos, int ypos) {
       if( ( xpos+fm.stringWidth(text) ) > d.width)
           xpos = X-5-fm.stringWidth(text);

       if((ypos-fm.getHeight()) < 0)
           ypos += 5+fm.getHeight();

       return new Point(xpos, ypos);
   }

   protected void paintCurve(Graphics g) {
       Dimension d = getSize();
       float x = xLeftMargin, oldX = -1;
       float y = yLowerMargin, oldY = -1;
       float xx;
       float temp;

       for(int i=minElement;i<=maxElement;i++){

           xx = script.getGraphData(index, (TElement)elements.get(new Integer(i)) );

           y = (   (maxY-xx)  /  (maxY-minY)   ) * (d.height-(yLowerMargin));
           if(oldY < 0.0) oldY = y;
           if(oldX < 0.0) oldX = x;

/* Notes: y / (maxY - minY) gets percentage along bar.
   Multiply by (d.height-30) to get real y
*/
           if(xx != invalid) {
               if(i == selectedAtom){
                   g.setColor(labelColor);
                   g.drawString("Selection: "+Float.toString(xx)+" "+units, 0, 15);
               }

               g.setColor(curveColor);
               g.drawLine((int)(Math.round(oldX)),(int)(Math.round(oldY)) ,
                   (int)(Math.round(x)),(int)(Math.round(y)));

               if(i == selectedAtom){
                   g.setColor(selectedColor);
                   g.drawLine((int)(Math.round(x)),0,(int)(Math.round(x)),d.height);
                   g.drawLine(0, (int)Math.round(y), d.width, (int)Math.round(y));//          (int)(Math.round(x)),0,(int)(Math.round(x)),d.height);

                   String yy = Float.toString(getGridY((int)Math.round(y)));
                   if(yy.length() > 5) yy = yy.substring(0,5);
                   String xxx = Float.toString(getGridX((int)Math.round(x)));
                   if(xxx.length() > 5) xxx = xxx.substring(0,5);

                   FontMetrics fm = g.getFontMetrics();
                   int xpos = (int)Math.round(x)+5;
                   String text = "("+xx+","+yy+")";
                   if(   ( xpos+fm.stringWidth(text) ) > d.width)
                       xpos = (int)Math.round(x)-5-fm.stringWidth(text);
                   int ypos = (int)Math.round(y) + 5 + g.getFontMetrics().getHeight();

                   if(bOpaqueCoords) {
                       g.setColor(new Color(0x66, 0x66, 0x99));
                       g.drawRect(xpos, ypos - fm.getHeight() , fm.stringWidth(text) + 10, fm.getHeight()+5);
                       g.setColor(new Color(0xCC, 0xCC, 0xFF));
                       g.fillRect(xpos+1, ypos - fm.getHeight()+1 , fm.stringWidth(text) + 9, fm.getHeight()+4);
                       g.setColor(locatorCaption);
                   }
                   
                   g.drawString(text, xpos+5, ypos );
                   g.setColor(axisColor);
               }
               oldX = x; oldY = y;
           } else {
               if(!bInterpolateMissing){
                   oldX = -1;
                   oldY = -1;
               }
           }
           x += stepX;
       }
   }

   private static Image iBuffer;
   private static int biw, bih;
   private static Image iBack;
   private boolean fontInited = false;

   public void update(Graphics g) {paint(g);}   

   public void paint(Graphics g){
       if((!fontInited)&&(getParent() != null)) {
           setFont(getParent().getFont());
           fontInited = true;
       }

       Dimension d = getSize();
       boolean dChanged = ((biw != d.width)||(bih != d.height));

       if( (iBuffer == null) || dChanged ) {
           if(emm != null)
               doMouseMove(emm.getX(), emm.getY());
           iBuffer = createImage(d.width,d.height);
           biw = d.width;
           bih = d.height;
       }

       if( (iBack == null) || dChanged ) {
           iBack = createImage(d.width,d.height);
       }

       Graphics gBuffer = iBuffer.getGraphics();
       gBuffer.setFont(getFont());

       if(dChanged || mustRepaint) {
           Graphics gBack = iBack.getGraphics();
           gBack.setFont(getFont());
           stepX = ((float)getSize().width-xLeftMargin-1) / (maxElement - minElement);
           stepY = ((float)getSize().height-yLowerMargin-1) / (maxY - minY);

           paintBackground(gBack);
           paintGrid(gBack);
           paintXAxis(gBack);
           paintYAxis(gBack);
           paintCurve(gBack);
       }
       gBuffer.drawImage(iBack, 0, 0, null);

       paintLocator(gBuffer);

       g.drawImage(iBuffer, 0, 0, null);
       mustRepaint = false;
   }

   public void mouseDragged(MouseEvent e){
       mouseMoved(e);
       ppmgr.setAtom((int)Math.round(gridX));
   }

   private MouseEvent emm = null;

   public void mouseMoved(MouseEvent e){
       doMouseMove(e.getX(), e.getY());
       emm = e;
   }

   private void doMouseMove(int x, int y) {
       if(x > xLeftMargin) X = x; else X = xLeftMargin;
       gridX = getGridX(X); if(gridX < 0) gridX = 0;

       if(!bDrawLocator) return;

       Dimension d = getSize();
       if(bLocatorFollowCurve) {
           int i = (int)Math.round(getGridX(x));
           if( (i < minElement) || (i > maxElement) ) {
               Y = (int)Math.round(invalid);
               return;
           }
           float ee = script.getGraphData(index, (TElement)elements.get(new Integer(i)) );
           Y = (int)Math.round(      ((maxY-ee)/(maxY-minY))*(d.height-(yLowerMargin))     );
       } else {
           if(y < d.height-yLowerMargin) Y = y; else Y = d.height-yLowerMargin;
       }

       gridY = getGridY(Y); if(gridY < 0) gridY = 0;

       repaint();
   }

   private int getPixelX(float X) { //gets x pixel from a grid xpos.
       Dimension d = getSize();
       float percent = X / (maxElement - minElement);
       return (int) Math.round( percent * (d.width - xLeftMargin) );
   }

   private int getPixelY(float Y) { //gets a y pixel from a grid ypos.
       Dimension d = getSize();
       float percent = 1 - ( Y / (maxY - minY) );
       return (int) Math.round( percent * (d.height - yLowerMargin) );
   }

   private float getGridY(int Y) { //gets a grid x from a x pixel.
       Dimension d = getSize();
       float height = d.height-yLowerMargin;
       float percent = 1 - (Y / height);
       return ((maxY-minY) * percent)+minY;
   }

   private float getGridX(int X) {
       Dimension d = getSize();
       float width = d.width-xLeftMargin;
       float percent = ((X-xLeftMargin) / width);
       return ((maxElement-minElement) * percent)+minElement;
   }

   public void mouseClicked(MouseEvent e) {
       ppmgr.setAtom((int)Math.round(gridX));
   }

   public void mousePressed(MouseEvent e) {}
   public void mouseReleased(MouseEvent e) {}
   public void mouseEntered(MouseEvent e) {}
   public void mouseExited(MouseEvent e) {}

   public void actionPerformed(ActionEvent e){
       String s = e.getActionCommand();
       if(s.equals("FileSaveGraph")) {
           OnFileSaveGraph();
       } else if (s.equals("FilePrintGraph")) {
       	OnFilePrintGraph();
       }
   }

   private void OnFileSaveGraph() {
     try {
	    SimpleFileFilter filter = new SimpleFileFilter("bmp", "Windows Bitmap");

       DoFileDialog d = new DoFileDialog(this, "Save Graph Image...", FileDialog.SAVE, filter);
       String fname = d.getPath();

       if(fname.equals("")) return;

       String ext = DoFileDialog.getExtension(fname);

       if(ext.equals(".bmp")) {
       	BitmapCodec bf = new BitmapCodec(this);
       	if(iBuffer == null) repaint();
       	bf.saveBitmap(fname, iBuffer);
       }
       sbb.setText("Saved.");
     } catch (Exception e){
       e.printStackTrace();
     }
   }

   public void onActivate(PanelEvent pe) {
   	activated = true;
       mustRepaint = true;
       repaint();
       ppmgr.addMenu(pmContext);
   }

   public void onDeactivate(PanelEvent pe) {
   	activated = true;
       ppmgr.removeMenu(pmContext);
   }

   public void setStyle(PanelEvent pe) {
       int style = pe.getStyle();
       bInterpolateMissing = ( (style & PanelEvent.GS_MISSINGPOINTS) != 0);
       bDrawLocator        = ( (style & PanelEvent.GS_LOCATOR) != 0);
       bLocatorFollowCurve = ( (style & PanelEvent.GS_STICKYLOCATOR) != 0);
       bOpaqueCoords       = ( (style & PanelEvent.GS_OPAQUECOORDS) != 0);
       mustRepaint = true;
       repaint();
   }
/*   public void setColorScheme(String s) {
       if(s.equals("Monochrome")){
           setBackground(Color.white);
           labelColor = Color.black;
           gridColor = new Color(208, 208, 208);
           locatorColor = Color.darkGray;
           locatorCaption = Color.black;
           axisColor = Color.black;
           selectedColor = Color.black;
           curveColor = Color.darkGray;
       } else { //this is "standard" scheme!
           setBackground(Color.black);
           labelColor = Color.white;
           gridColor = darkGreen;
           locatorColor = lightBlue;
           locatorCaption = Color.black;
           axisColor = Color.white;
           selectedColor = Color.red;
           curveColor = lightGreen;
       }
       mustRepaint = true;
       repaint();
   }*/
   public String toString() {return caption;}

   private void OnFilePrintGraph() {
/*   	PrinterJob printJob = PrinterJob.getPrinterJob();
       PageFormat pf = printJob.defaultPage();
       pf.setOrientation(PageFormat.LANDSCAPE);
		printJob.setPrintable(this, pf);
       printJob.setJobName(toString());
       if(printJob.printDialog())
   		try { printJob.print(); } catch (Exception PrintException) { }
   }

   public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
       if (pi >= 1) return Printable.NO_SUCH_PAGE;

       Graphics g2 = (Graphics) g;
       g2.translate(pf.getImageableX(), pf.getImageableY());
       Font f = Font.getFont ("Courier");
//       System.out.println (f);
       g2.setFont (f);
       paint (g2);
       return Printable.PAGE_EXISTS;
*/   }

   public void updateUI() {
       super.updateUI();
       if(pmContext != null) pmContext.updateUI();
   }
}
