import java.io.*;

public class LeetOutputStream extends OutputStream {
	private OutputStream realout;
	private char lastchar;

	public LeetOutputStream(OutputStream o) {
		lastchar = 0;
		realout = o;
	}

	public void write(int b) throws IOException {
		char c = (char)b;

		if(lastchar != 0) {
			if(c == ' ' || c == '.') {
				if(lastchar == 's' || lastchar == 'S') {
					realout.write('z');
				}
				realout.write(c);
				lastchar = 0;
				return;
			}
			realout.write(lastchar);
			lastchar = 0;
		}

		switch(c) {
			case 'e':
			case 'E':
				realout.write('3');
				break;
			case 'l':
			case 'L':
				realout.write('1');
				break;
			case 't':
			case 'T':
				realout.write('7');
				break;
			case 'a':
			case 'A':
				realout.write('4');
				break;
			case 'o':
			case 'O':
				realout.write('0');
				break;
			case 's':
			case 'S':
				lastchar = c;
				break;
			default:
				realout.write(b);
		}

		//realout.flush();
	}

	public void flush() throws IOException {
		realout.flush();
	}

	public void close() throws IOException {
		realout.close();
	}
}
