package jrand;

import java.util.*;

public final class CFGNode {
	/* there are four types of CFGNode:
	   1) An unresolved pointer to another declaration.
	   2) A resolved pointer to another declaration.
	   3) A string.
	   4) A combination of nodes.
	 */
	public final static int UNRESOLVED = 1;
	public final static int RESOLVED = 2;
	public final static int STRING = 3;
	public final static int COMBINATION = 4;

	private int type;
	
	private String upointer;	//(1)
	private CFGNode rpointer;	//(2)
	private String text;		//(3)
	private Vector nodes;		//(4)

	private CFGNode next, prev;
	
	private CFGNode() {}

	public CFGNode(int typ, String data) {
		type = typ;
		if(type == UNRESOLVED) {
			upointer = data;
		} else if(type == STRING) {
			text = data;
		} else {
			System.err.println("Invalid Node type: "+type);
		}
	}

	public CFGNode(int typ) {
		type = typ;
		if(typ != COMBINATION) {
			System.err.println("Invalid Node type: "+type);
			return;
		}
		nodes = new Vector();
	}

	//code to handle combinations
	public final void addPossibility(CFGNode moo) {
		if(type != COMBINATION) {
			System.err.println("Trying to add possibility to type "+type+" node.");
			return;
		}
		nodes.addElement(moo);
	}
	public final int getPossibilityCount() {return nodes.size();}
	public final CFGNode getPossibility(int num) {
		return (CFGNode)nodes.elementAt(num);
	}
	public final int getIndexOfPossibility(CFGNode poss) {
		return nodes.indexOf(poss);
	}
	
	//code to handle links
	public final void resolveNode(CFGList list) {
		if(type == RESOLVED) return; //already resolved; go away.
		else if(type == COMBINATION) {
			Enumeration e = nodes.elements();

			while(e.hasMoreElements()) {
				((CFGNode)e.nextElement()).resolveNode(list);
			}
		} else if(type == UNRESOLVED) {
			rpointer = list.getRule(upointer);
			if(rpointer == null) {
				System.err.println("Error: Could not resolve node "+upointer+"!");
				return;
			}
			type = RESOLVED;
		}
		if(getNext() != null) getNext().resolveNode(list);
	}

	public final void setNext(CFGNode nex) {next = nex;}
	public final CFGNode getNext() {return next;}

	public final void setPrev(CFGNode pre) {prev = pre;}
	public final CFGNode getPrev() {return prev;}

	public final String toString() {
		StringBuffer sb = new StringBuffer();
		switch(type) {
			case UNRESOLVED:
			case RESOLVED:
				sb.append("<"+upointer+">");
				break;
			case STRING:
				sb.append("\""+encode(text)+"\"");
				break;
			case COMBINATION:
				Enumeration e;

				e = nodes.elements();

				while(e.hasMoreElements()) {
					sb.append( ((CFGNode)e.nextElement()).toString() );
					if(e.hasMoreElements())
						sb.append(" | ");
				}
				break;
			default: sb.append("?"); break;
		}
		if(getNext() != null) {
			sb.append(" ");
			sb.append(getNext().toString());
		}
		return sb.toString();
	}

	public final int getType() {return type;}

	public final String getUPointer() {return upointer;}
	public final String getText() {return text;}
	public final CFGNode getRPointer() {return rpointer;}

	private final String encode(String moo) {
		StringBuffer sb = new StringBuffer();
		int len = moo.length();

		for(int i = 0; i < len; i++) {
			char c = moo.charAt(i);
			switch(c) {
				case '\n':
					sb.append("\\n");
					break;
				case '\"':
					sb.append("\\\"");
					break;
				case '\\':
					sb.append("\\\\");
					break;
				default:
					sb.append(c);
					break;
			}
		}
		return sb.toString();
	}
}
