package jrand.ui;

import javax.swing.event.*;
import javax.swing.tree.*;
import java.util.Vector;
import jrand.*;

public class CFGNodeModel implements TreeModel {
	private Vector treeModelListeners = new Vector();
	private CFGNode root;

	public CFGNodeModel(CFGNode r00t) {
		root = r00t;
	}

	/**
	 * Used to toggle between show ancestors/show descendant and
	 * to change the root of the tree.
	 */
	 /*
	public void showAncestor(boolean b, Object newRoot) {
		showAncestors = b;
		Person oldRoot = rootPerson;
		if (newRoot != null) {
		   rootPerson = (Person)newRoot;
		}
		fireTreeStructureChanged(oldRoot);
	}
	*/

//////////////// Fire events //////////////////////////////////////////////

	/**
	 * The only event raised by this model is TreeStructureChanged with the
	 * root as path, i.e. the whole tree has changed.
	 */
/*
	protected void fireTreeStructureChanged(Person oldRoot) {
		int len = treeModelListeners.size();
		TreeModelEvent e = new TreeModelEvent(this, 
			new Object[] {oldRoot});
		for (int i = 0; i < len; i++) {
			((TreeModelListener)treeModelListeners.elementAt(i)).
				treeStructureChanged(e);
		}
	}
*/

//////////////// TreeModel interface implementation ///////////////////////


	/**
	 * Adds a listener for the TreeModelEvent posted after the tree changes.
	 */
	public void addTreeModelListener(TreeModelListener l) {
		treeModelListeners.addElement(l);
	}

	/**
	 * Returns the child of parent at index index in the parent's child array.
	 */
	public Object getChild(Object parent, int index) {
		CFGNode cn = (CFGNode)parent;
		return cn.getPossibility(index);
	}

	/**
	 * Returns the number of children of parent.
	 */
	public int getChildCount(Object parent) {
		CFGNode cn = (CFGNode)parent;
		
		return cn.getPossibilityCount();
	}

	/**
	 * Returns the index of child in parent.
	 */
	public int getIndexOfChild(Object parent, Object child) {
		CFGNode cn = (CFGNode)parent;
		return cn.getIndexOfPossibility((CFGNode)child);
	}

	/**
	 * Returns the root of the tree.
	 */
	public Object getRoot() {
		return root;
	}

	/**
	 * Returns true if node is a leaf.
	 */
	public boolean isLeaf(Object node) {
		CFGNode cn = (CFGNode)node;

		switch(cn.getType()) {
			case CFGNode.UNRESOLVED:
			case CFGNode.RESOLVED:
			case CFGNode.STRING:
				return false;
			case CFGNode.COMBINATION:
				return true;
			default: //???
				return true;
		}
	}

	/**
	 * Removes a listener previously added with addTreeModelListener().
	 */
	public void removeTreeModelListener(TreeModelListener l) {
		treeModelListeners.removeElement(l);
	}

	/**
	 * Messaged when the user has altered the value for the item
	 * identified by path to newValue.  Not used by this model.
	 */
	public void valueForPathChanged(TreePath path, Object newValue) {
		System.out.println("*** valueForPathChanged : "
						   + path + " --> " + newValue);
	}
}
